/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.vo;

import eu.geclipse.aws.IAWSService;
import eu.geclipse.aws.IAWSServiceCreator;
import eu.geclipse.aws.internal.Activator;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.ICreatorSourceMatcher;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.impl.AbstractGridElementCreator;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSVoCreator
extends AbstractGridElementCreator
implements ICreatorSourceMatcher {
    private static List<IAWSServiceCreator> serviceCreatorList;
    private static final String EXTENSION_ID = "eu.geclipse.aws.vo.awsVoCreator";
    private String voName;
    private String awsAccessId;

    public boolean canCreate(Object source) {
        boolean result = false;
        if (source instanceof IFileStore) {
            IFileStore propertiesStore = ((IFileStore)source).getChild(".aws_vo_properties");
            IFileInfo propertiesInfo = propertiesStore.fetchInfo();
            result = propertiesInfo.exists();
        }
        return result;
    }

    public IGridElement create(IGridContainer parent) throws ProblemException {
        AWSVirtualOrganization vo = null;
        Object source = this.getSource();
        if (source == null) {
            vo = new AWSVirtualOrganization(this);
        } else if (source instanceof IFileStore) {
            vo = new AWSVirtualOrganization((IFileStore)source);
        }
        return vo;
    }

    public static synchronized List<IAWSServiceCreator> getAWSServiceCreators() {
        if (serviceCreatorList == null) {
            serviceCreatorList = new ArrayList<IAWSServiceCreator>();
            List configurationElements = GridModel.getCreatorRegistry().getConfigurations(null, IAWSService.class);
            for (IConfigurationElement configElem : configurationElements) {
                try {
                    IConfigurationElement[] sourceChildern;
                    IAWSServiceCreator serviceCreator = (IAWSServiceCreator)configElem.createExecutableExtension("class");
                    IConfigurationElement[] iConfigurationElementArray = sourceChildern = configElem.getChildren("source");
                    int n = sourceChildern.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement sourceElement = iConfigurationElementArray[n2];
                        String defaultSource = sourceElement.getAttribute("default");
                        boolean isDefaultSource = Boolean.parseBoolean(defaultSource);
                        if (isDefaultSource) {
                            serviceCreator.setServiceURL(sourceElement.getAttribute("pattern"));
                            serviceCreator.setName(configElem.getAttribute("name"));
                        }
                        ++n2;
                    }
                    serviceCreatorList.add(serviceCreator);
                }
                catch (CoreException coreEx) {
                    Activator.log("Could not create AWS service creator from extension definition: " + configElem.getValue(), (Exception)((Object)coreEx));
                }
                catch (ClassCastException castEx) {
                    Activator.log("Given creator is not an instance of IAWSServiceCreator: " + configElem.getValue(), castEx);
                }
            }
        }
        return serviceCreatorList;
    }

    public String getVoName() {
        return this.voName;
    }

    public void setVoName(String voName) {
        this.voName = voName;
    }

    public void apply(AWSVirtualOrganization awsVo) {
        try {
            awsVo.apply(this);
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not populate AWSVirtualOrganization with the data from the AWSVoCreator", (Exception)((Object)problemEx));
        }
    }

    public String getExtensionID() {
        return EXTENSION_ID;
    }

    public String getAwsAccessId() {
        return this.awsAccessId;
    }

    public void setAwsAccessId(String awsAccessId) {
        this.awsAccessId = awsAccessId;
    }
}

