/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui;

import eu.geclipse.batch.IBatchService;
import eu.geclipse.batch.IBatchServiceDescription;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchServiceManager
implements IContentChangeNotifier {
    private static volatile BatchServiceManager singleton = null;
    private List<IBatchService> services = new ArrayList<IBatchService>();
    private ListenerList ccListeners = new ListenerList();

    private BatchServiceManager() {
    }

    public static BatchServiceManager getManager() {
        if (singleton == null) {
            singleton = new BatchServiceManager();
        }
        return singleton;
    }

    public IBatchService createService(IBatchServiceDescription description, String name) throws ProblemException {
        IBatchService service = description.createService(name);
        this.addService(service);
        return service;
    }

    public IBatchService findToken(IBatchServiceDescription description) {
        IBatchService resultService = null;
        for (IBatchService service : this.services) {
            if (!service.getDescription().equals(description)) continue;
            resultService = service;
            break;
        }
        return resultService;
    }

    public List<IBatchService> getServices() {
        return new ArrayList<IBatchService>(this.services);
    }

    public List<IBatchService> getServices(String typeName) {
        ArrayList<IBatchService> newList = new ArrayList<IBatchService>();
        for (IBatchService service : this.services) {
            if (!service.getDescription().getServiceTypeName().equals(typeName)) continue;
            newList.add(service);
        }
        return newList;
    }

    public void destroyService(IBatchService service) {
        this.removeService(service);
        service.disconnectFromServer();
    }

    public int getServiceCount() {
        return this.services.size();
    }

    public boolean isEmpty() {
        return this.getServiceCount() == 0;
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        this.ccListeners.add((Object)listener);
    }

    public void removeContentChangeListener(IContentChangeListener listener) {
        this.ccListeners.remove((Object)listener);
    }

    protected void addService(IBatchService service) {
        this.services.add(service);
        this.fireContentChanged();
    }

    protected boolean removeService(IBatchService service) {
        boolean result = this.services.remove(service);
        if (result) {
            this.fireContentChanged();
        }
        return result;
    }

    protected void fireContentChanged() {
        Object[] list = this.ccListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof IContentChangeListener) {
                IContentChangeListener listener = (IContentChangeListener)list[i];
                listener.contentChanged((IContentChangeNotifier)this);
            }
            ++i;
        }
    }
}

