/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.dialogs;

import eu.geclipse.batch.IBatchJobInfo;
import eu.geclipse.batch.ui.internal.Messages;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BatchJobInfoDialog
extends IconAndMessageDialog {
    private IBatchJobInfo job;

    public BatchJobInfoDialog(IBatchJobInfo job, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(68848);
        this.job = job;
    }

    protected IBatchJobInfo getJob() {
        return this.job;
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        gData.widthHint = 450;
        gData.heightHint = 250;
        mainComp.setLayoutData((Object)gData);
        Label idLabel = new Label(mainComp, 16384);
        idLabel.setText(Messages.getString("BatchJobInfoDialog.job_id_label"));
        gData = new GridData();
        gData.horizontalAlignment = 1;
        idLabel.setLayoutData((Object)gData);
        Text idText = new Text(mainComp, 18432);
        idText.setText(this.job.getJobId());
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        idText.setLayoutData((Object)gData);
        idText.setEditable(false);
        Label nameLabel = new Label(mainComp, 16384);
        nameLabel.setText(Messages.getString("BatchJobInfoDialog.job_name_label"));
        gData = new GridData();
        gData.horizontalAlignment = 1;
        nameLabel.setLayoutData((Object)gData);
        Text nameText = new Text(mainComp, 18432);
        nameText.setText(this.job.getJobName());
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        nameText.setLayoutData((Object)gData);
        nameText.setEditable(false);
        Label queueNameLabel = new Label(mainComp, 16384);
        queueNameLabel.setText(Messages.getString("BatchJobInfoDialog.job_queue_name_label"));
        gData = new GridData();
        gData.horizontalAlignment = 1;
        queueNameLabel.setLayoutData((Object)gData);
        Text queueNameText = new Text(mainComp, 18432);
        queueNameText.setText(this.job.getQueueName());
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        queueNameText.setLayoutData((Object)gData);
        queueNameText.setEditable(false);
        Label userAccountLabel = new Label(mainComp, 16384);
        userAccountLabel.setText(Messages.getString("BatchJobInfoDialog.job_user_account_label"));
        gData = new GridData();
        gData.horizontalAlignment = 1;
        userAccountLabel.setLayoutData((Object)gData);
        Text userAccountText = new Text(mainComp, 18432);
        userAccountText.setText(this.job.getUserAccount());
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        userAccountText.setLayoutData((Object)gData);
        userAccountText.setEditable(false);
        Label statusLabel = new Label(mainComp, 16384);
        statusLabel.setText(Messages.getString("BatchJobInfoDialog.job_status_label"));
        gData = new GridData();
        gData.horizontalAlignment = 1;
        statusLabel.setLayoutData((Object)gData);
        Text statusText = new Text(mainComp, 18432);
        statusText.setText(this.job.getStatus().toString());
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        statusText.setLayoutData((Object)gData);
        statusText.setEditable(false);
        Label timeUsedLabel = new Label(mainComp, 16384);
        timeUsedLabel.setText(Messages.getString("BatchJobInfoDialog.job_time_used_label"));
        gData = new GridData();
        gData.horizontalAlignment = 1;
        timeUsedLabel.setLayoutData((Object)gData);
        Text timeUsedText = new Text(mainComp, 18432);
        timeUsedText.setText(this.job.getTimeUse());
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        timeUsedText.setLayoutData((Object)gData);
        timeUsedText.setEditable(false);
        return mainComp;
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    protected Control createInfoArea(Composite parent) {
        Composite mainComp = new Composite(parent, 2048);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(mainComp, 0);
        label.setText(Messages.getString("BatchJobInfoDialog.no_info_label"));
        GridData gData = new GridData();
        label.setLayoutData((Object)gData);
        return mainComp;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String type = this.job.getServiceTypeName();
        String batchType = type != null ? this.job.getServiceTypeName() : Messages.getString("BatchJobInfoDialog.unknown");
        shell.setText(String.valueOf(batchType) + " " + Messages.getString("BatchJobInfoDialog.info_suffix"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, Messages.getString("BatchJobInfoDialog.close"), false);
    }
}

