/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.dialogs;

import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class ProgressDialog
extends Dialog {
    private volatile boolean isClosed = false;
    private String processMessage = Messages.getString("ProgressDialog.PleaseWait");
    private String shellTitle;
    private Image[] processImages = new Image[]{Activator.getDefault().getImageRegistry().get("busyArrow1Icon"), Activator.getDefault().getImageRegistry().get("busyArrow2Icon"), Activator.getDefault().getImageRegistry().get("busyArrow3Icon"), Activator.getDefault().getImageRegistry().get("busyArrow4Icon")};
    private Label processMessageLabel;
    private Button closeButton;
    private Composite cancelComposite;
    private Label lineLabel;
    private Composite progressBarComposite;
    private CLabel message;
    private ProgressBar progressBar;
    private Shell shell;
    private Display display = null;
    private int majorTasks = 0;
    private int minorTasks = 0;
    private int currentMajorTask = 0;
    private int currentMinorTasks;
    private int currentMajorOffset;
    private double currentMinorOffset;
    private int progressTiks = 100;
    private String[] taskDescriptions = null;

    public ProgressDialog(Shell parent) {
        super(parent);
    }

    public void initInformation(int numMajorTasks, String[] descriptions, String dialogTitle) {
        this.majorTasks = numMajorTasks;
        this.shellTitle = dialogTitle;
        this.taskDescriptions = new String[this.majorTasks];
        if (descriptions == null) {
            int i = 0;
            while (i < this.majorTasks) {
                this.taskDescriptions[i] = String.valueOf(Messages.getString("ProgressDialog.WorkOnTask")) + i;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.majorTasks) {
                this.taskDescriptions[i] = String.valueOf(Messages.getString("ProgressDialog.WorkOnTask")) + descriptions[i];
                ++i;
            }
        }
    }

    public void moveNextMajorTask(int numMinTasks) {
        if (!this.isClosed) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    ProgressDialog.this.processMessageLabel.setText(ProgressDialog.this.taskDescriptions[ProgressDialog.this.currentMajorTask]);
                }
            });
        }
        this.minorTasks = numMinTasks;
        this.currentMinorTasks = 0;
        ++this.currentMajorTask;
        this.currentMajorOffset = this.progressTiks / this.majorTasks * (this.currentMajorTask - 1);
        this.currentMinorOffset = (double)(this.progressTiks / this.majorTasks) / (double)this.minorTasks;
    }

    public void moveNextMinor() {
        ++this.currentMinorTasks;
        if (!this.isClosed) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    int selection = ProgressDialog.this.currentMajorOffset + (int)Math.floor((double)ProgressDialog.this.currentMinorTasks * ProgressDialog.this.currentMinorOffset);
                    ProgressDialog.this.progressBar.setSelection(selection);
                    ProgressDialog.this.message.setImage(ProgressDialog.this.processImages[ProgressDialog.this.currentMinorTasks % 4]);
                }
            });
        }
    }

    public void open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
    }

    public void close() {
        this.display.syncExec(new Runnable(){

            public void run() {
                ProgressDialog.this.isClosed = true;
                ProgressDialog.this.shell.dispose();
            }
        });
    }

    protected void createContents() {
        Point dialogSize = new Point(480, 180);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        this.shell = new Shell(this.getParent(), 32800);
        this.display = this.shell.getDisplay();
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setSize(dialogSize);
        this.shell.setText(this.shellTitle);
        Rectangle shellBounds = this.getParent().getBounds();
        this.shell.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(4, 2, true, false));
        composite.setLayout((Layout)new GridLayout());
        this.message = new CLabel(composite, 0);
        this.message.setImage(this.processImages[0]);
        this.message.setLayoutData((Object)new GridData(4, 2, true, false));
        this.message.setText(this.processMessage);
        this.progressBarComposite = new Composite((Composite)this.shell, 0);
        this.progressBarComposite.setLayoutData((Object)new GridData(4, 2, false, false));
        this.progressBarComposite.setLayout((Layout)new FillLayout());
        this.progressBar = new ProgressBar(this.progressBarComposite, 65536);
        this.progressBar.setMaximum(this.progressTiks);
        this.processMessageLabel = new Label((Composite)this.shell, 0);
        this.processMessageLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        this.lineLabel = new Label((Composite)this.shell, 258);
        this.lineLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        this.cancelComposite = new Composite((Composite)this.shell, 0);
        this.cancelComposite.setLayoutData((Object)new GridData(3, 2, false, false));
        GridLayout gridLayoutCancel = new GridLayout();
        gridLayoutCancel.numColumns = 2;
        this.cancelComposite.setLayout((Layout)gridLayoutCancel);
        this.closeButton = new Button(this.cancelComposite, 0);
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressDialog.this.isClosed = true;
                ProgressDialog.this.shell.dispose();
            }
        });
        this.closeButton.setLayoutData((Object)new GridData(80, -1));
        this.closeButton.setText(Messages.getString("ProgressDialog.Close"));
        this.closeButton.setEnabled(true);
    }
}

