/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.editors;

import eu.geclipse.batch.BatchConnectionInfo;
import eu.geclipse.batch.Extensions;
import eu.geclipse.batch.IBatchService;
import eu.geclipse.batch.IBatchServiceDescription;
import eu.geclipse.batch.ISSHConnectionInfo;
import eu.geclipse.batch.ui.BatchServiceManager;
import eu.geclipse.batch.ui.editors.BatchEditorContextMenuProvider;
import eu.geclipse.batch.ui.internal.BatchUpdate;
import eu.geclipse.batch.ui.internal.BoxSortName;
import eu.geclipse.batch.ui.internal.BoxSortState;
import eu.geclipse.batch.ui.internal.ComputingElementAction;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.QueueDeleteAction;
import eu.geclipse.batch.ui.internal.QueueEnDisAction;
import eu.geclipse.batch.ui.internal.QueueStartStopAction;
import eu.geclipse.batch.ui.internal.SSHConnectionInfo;
import eu.geclipse.batch.ui.internal.WorkerNodeAction;
import eu.geclipse.batch.ui.internal.model.BatchDiagram;
import eu.geclipse.batch.ui.internal.parts.BatchEditPartFactory;
import eu.geclipse.batch.ui.internal.parts.BatchTreeEditPartFactory;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class BatchEditor
extends GraphicalEditor {
    public int queueByName = 0;
    public int sortedQ = 0;
    public int sortedN = 0;
    public int workerNodeByName = 0;
    public int queueByState = 0;
    public int workerNodeByState = 0;
    protected BatchUpdate updateJob;
    protected BatchConnectionInfo batchInfo = null;
    private BatchDiagram diagram;
    private IBatchService batchWrapper;

    public BatchEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void configureGraphicalViewer() {
        if (this.batchInfo != null) {
            super.configureGraphicalViewer();
            ScalableFreeformRootEditPart root = new ScalableFreeformRootEditPart();
            GraphicalViewer viewer = this.getGraphicalViewer();
            viewer.setEditPartFactory((EditPartFactory)new BatchEditPartFactory());
            viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
            viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
            viewer.setRootEditPart((RootEditPart)root);
            BatchEditorContextMenuProvider cmProvider = new BatchEditorContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
            viewer.setContextMenu((MenuManager)cmProvider);
            this.getEditorSite().registerContextMenu("eu.geclipse.batch.ui.contextmenu", (MenuManager)cmProvider, this.getSite().getSelectionProvider(), false);
            ArrayList<String> zoomLevels = new ArrayList<String>(3);
            zoomLevels.add(ZoomManager.FIT_ALL);
            zoomLevels.add(ZoomManager.FIT_WIDTH);
            zoomLevels.add(ZoomManager.FIT_HEIGHT);
            root.getZoomManager().setZoomLevelContributions(zoomLevels);
            ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
            this.getActionRegistry().registerAction((IAction)zoomIn);
            ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
            this.getActionRegistry().registerAction((IAction)zoomOut);
        }
    }

    public Object getAdapter(Class type) {
        Object obj = null;
        obj = ZoomManager.class == type ? this.getGraphicalViewer().getProperty(ZoomManager.class.toString()) : (IContentOutlinePage.class == type ? new BatchOutlinePage((EditPartViewer)new TreeViewer()) : super.getAdapter(type));
        return obj;
    }

    protected BatchDiagram getModel() {
        return this.diagram;
    }

    protected void initializeGraphicalViewer() {
        if (this.batchInfo != null) {
            GraphicalViewer viewer = this.getGraphicalViewer();
            viewer.setContents((Object)this.getModel());
            SSHConnectionInfo sshInfo = new SSHConnectionInfo(this.batchInfo.getAccount(), this.batchInfo.getBatchName(), null, null, 22);
            try {
                if (this.batchWrapper.connectToServer((ISSHConnectionInfo)sshInfo)) {
                    this.updateJob = new BatchUpdate(this.getSite().getShell(), this.diagram, this.batchWrapper, this.batchInfo.getBatchName(), this.batchInfo.getBatchType(), this.batchInfo.getUpdateInterval(), this);
                    this.updateJob.startUpdate();
                }
            }
            catch (ProblemException gExc) {
                ProblemDialog.openProblem(null, (String)Messages.getString("BatchEditor.Connection.Error"), null, (Throwable)gExc);
            }
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        boolean error = false;
        boolean found = false;
        IFile file = ((IFileEditorInput)input).getFile();
        this.batchInfo = new BatchConnectionInfo(file);
        try {
            this.batchInfo.load();
        }
        catch (ProblemException e) {
            error = true;
            ProblemDialog.openProblem((Shell)this.getSite().getShell(), (String)Messages.getString("BatchEditor.Error.LoadConfFileTitle"), (String)Messages.getString("BatchEditor.Error.LoadConfFile"), (Throwable)e);
        }
        if (!error) {
            List services = Extensions.getRegisteredBatchServiceDescriptions();
            for (IBatchServiceDescription description : services) {
                if (!description.supportsService(this.batchInfo.getBatchType())) continue;
                try {
                    this.batchWrapper = BatchServiceManager.getManager().createService(description, file.getName());
                    found = true;
                }
                catch (ProblemException e) {
                    error = true;
                    ProblemDialog.openProblem((Shell)this.getSite().getShell(), (String)Messages.getString("BatchEditor.Error.CreateServiceTitle"), (String)Messages.getString("BatchEditor.Error.CreateService"), (Throwable)e);
                }
                this.setPartName(file.getName());
                this.diagram = new BatchDiagram();
                break;
            }
        }
        if (!found) {
            this.batchInfo = null;
        }
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        SelectionAction action = new WorkerNodeAction((IWorkbenchPart)this, this.batchWrapper);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new QueueEnDisAction((IWorkbenchPart)this, this.batchWrapper);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new QueueStartStopAction((IWorkbenchPart)this, this.batchWrapper);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new QueueDeleteAction((IWorkbenchPart)this, this.batchWrapper);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ComputingElementAction((IWorkbenchPart)this, this.batchWrapper);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new BoxSortName((IWorkbenchPart)this, this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new BoxSortState((IWorkbenchPart)this, this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    public void dispose() {
        if (this.updateJob != null) {
            this.updateJob.stopUpdate();
        }
        if (this.batchWrapper != null) {
            BatchServiceManager.getManager().destroyService(this.batchWrapper);
        }
        super.dispose();
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public class BatchOutlinePage
    extends ContentOutlinePage {
        public BatchOutlinePage(EditPartViewer viewer) {
            super(viewer);
        }

        public void createControl(Composite parent) {
            if (BatchEditor.this.batchInfo != null) {
                this.getViewer().createControl(parent);
                this.getViewer().setEditDomain((EditDomain)BatchEditor.this.getEditDomain());
                this.getViewer().setEditPartFactory((EditPartFactory)new BatchTreeEditPartFactory());
                BatchEditorContextMenuProvider cmProvider = new BatchEditorContextMenuProvider(this.getViewer(), BatchEditor.this.getActionRegistry());
                this.getViewer().setContextMenu((MenuManager)cmProvider);
                this.getSite().registerContextMenu("eu.geclipse.batch.ui.contextmenu", (MenuManager)cmProvider, this.getSite().getSelectionProvider());
                BatchEditor.this.getSelectionSynchronizer().addViewer(this.getViewer());
                this.getViewer().setContents((Object)BatchEditor.this.getModel());
            }
        }

        public void dispose() {
            BatchEditor.this.getSelectionSynchronizer().removeViewer(this.getViewer());
            super.dispose();
        }

        public Control getControl() {
            return this.getViewer().getControl();
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            ActionRegistry registry = BatchEditor.this.getActionRegistry();
            IActionBars bars = pageSite.getActionBars();
            String id = ActionFactory.UNDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.REDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "org.eclipse.gef.zoom_in";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "org.eclipse.gef.zoom_out";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "WorkerNodeAction.ChangeStatus";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "QueueEnDisAction.EnableDisable";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "QueueStartStopAction.StartStop";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "QueueAction.DeleteQueue";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "ComputingElementAction.NewQueue";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "BoxSortByName";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "BoxSortByState";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            bars.updateActionBars();
        }
    }
}

