/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal;

import eu.geclipse.batch.BatchJobInfo;
import eu.geclipse.batch.IBatchJobInfo;
import eu.geclipse.batch.IBatchJobManager;
import eu.geclipse.batch.IBatchService;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchJobManager
implements IBatchJobManager,
IContentChangeNotifier {
    private LinkedHashMap<String, IBatchJobInfo> jobs = new LinkedHashMap();
    private ListenerList ccListeners = new ListenerList();
    private boolean done = false;

    public synchronized IBatchJobInfo findJob(String jobId) {
        return this.jobs.get(jobId);
    }

    public synchronized void removeOld(List<IBatchJobInfo> currentActiveJobs) {
        boolean changed = false;
        Iterator<String> iter = this.jobs.keySet().iterator();
        while (iter.hasNext()) {
            String jobId = iter.next();
            boolean found = false;
            int i = 0;
            while (i < currentActiveJobs.size()) {
                IBatchJobInfo jobInfo = currentActiveJobs.get(i);
                if (jobId.equals(jobInfo.getJobId())) {
                    found = true;
                }
                ++i;
            }
            if (found) continue;
            iter.remove();
            changed = true;
        }
        if (changed) {
            this.fireContentChanged();
        }
    }

    public synchronized IBatchJobInfo addMerge(String jobId, String jobName, String userAccount, String timeUse, IBatchJobInfo.JobState status, String queueName, IBatchService batchWrapper) {
        IBatchJobInfo jobInfo = null;
        boolean changed = false;
        if (!this.done) {
            jobInfo = this.findJob(jobId);
            if (jobInfo == null) {
                jobInfo = new BatchJobInfo(jobId, jobName, userAccount, timeUse, status, queueName, batchWrapper);
                this.jobs.put(jobId, jobInfo);
                changed = true;
            } else {
                if (jobInfo.getStatus() != status) {
                    jobInfo.setStatus(status);
                    changed = true;
                }
                if (!jobInfo.getTimeUse().equals(timeUse)) {
                    jobInfo.setTimeUse(timeUse);
                    changed = true;
                }
            }
        }
        if (changed) {
            this.fireContentChanged();
        }
        return jobInfo;
    }

    public synchronized List<IBatchJobInfo> getJobs() {
        return new ArrayList<IBatchJobInfo>(this.jobs.values());
    }

    public synchronized List<IBatchJobInfo> getJobs(String queueName) {
        ArrayList<IBatchJobInfo> retJobs = new ArrayList<IBatchJobInfo>();
        for (IBatchJobInfo jobInfo : this.jobs.values()) {
            if (!jobInfo.getQueueName().equals(queueName)) continue;
            retJobs.add(jobInfo);
        }
        return retJobs;
    }

    public synchronized List<IBatchJobInfo> getJobs(List<String> jobIds) {
        ArrayList<IBatchJobInfo> retJobs = new ArrayList<IBatchJobInfo>();
        for (String jobId : jobIds) {
            IBatchJobInfo jobInfo = this.jobs.get(jobId);
            if (jobInfo == null) continue;
            retJobs.add(jobInfo);
        }
        return retJobs;
    }

    public synchronized int getJobCount() {
        return this.jobs.size();
    }

    public synchronized boolean isEmpty() {
        return this.getJobCount() == 0;
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        this.ccListeners.add((Object)listener);
    }

    public void removeContentChangeListener(IContentChangeListener listener) {
        this.ccListeners.remove((Object)listener);
    }

    protected boolean removeJob(IBatchJobInfo job) {
        IBatchJobInfo removedJob = (IBatchJobInfo)this.jobs.remove(job.getJobId());
        return removedJob != null;
    }

    public void deleteJob(IBatchJobInfo job) throws ProblemException {
        if (job.isDeletable()) {
            job.deleteJob();
            this.removeJob(job);
        }
    }

    public void moveJob(IBatchJobInfo job, String destQueue, String destServer) throws ProblemException {
        if (job.isMovable()) {
            job.moveJob(destQueue, destServer);
            this.removeJob(job);
        }
    }

    public void holdJob(IBatchJobInfo job) throws ProblemException {
        if (job.isHoldable()) {
            job.holdJob();
            job.setStatus(IBatchJobInfo.JobState.H);
        }
    }

    public void releaseJob(IBatchJobInfo job) throws ProblemException {
        if (job.isReleasable()) {
            job.releaseJob();
            job.setStatus(IBatchJobInfo.JobState.Q);
        }
    }

    public void reRunJob(IBatchJobInfo job) throws ProblemException {
        if (job.isReRunnable()) {
            job.reRunJob();
        }
    }

    public synchronized void removeAll() {
        this.done = true;
        this.jobs.clear();
        this.fireContentChanged();
    }

    protected synchronized void fireContentChanged() {
        Object[] list = this.ccListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof IContentChangeListener) {
                IContentChangeListener listener = (IContentChangeListener)list[i];
                listener.contentChanged((IContentChangeNotifier)this);
            }
            ++i;
        }
    }
}

