/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal;

import eu.geclipse.batch.ISSHConnectionInfo;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.core.auth.PasswordManager;
import eu.geclipse.ui.dialogs.PasswordDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class SSHConnectionInfo
implements ISSHConnectionInfo {
    private String user;
    private String host;
    private String passwd;
    private String passphrase;
    private int port;
    private boolean canceledPWValue;
    private int promptPasswd;

    public SSHConnectionInfo(String username, String hostname, String password, String passphrase, int portNumber) {
        this.user = username;
        this.host = hostname;
        if (password == null) {
            this.passwd = PasswordManager.getPassword((String)(String.valueOf(username) + '@' + hostname));
        } else if (password.length() != 0) {
            PasswordManager.registerPassword((String)(String.valueOf(username) + '@' + hostname), (String)password);
            this.passwd = password;
        }
        this.promptPasswd = this.passwd != null && this.passwd.length() != 0 ? 0 : 1;
        this.passphrase = passphrase;
        this.port = portNumber;
        this.canceledPWValue = false;
    }

    public String getPassword() {
        ++this.promptPasswd;
        return this.passwd;
    }

    public String getUsername() {
        return this.user;
    }

    public String getHostname() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public boolean promptYesNo(String str) {
        return MessageDialog.openQuestion(null, (String)Messages.getString("SSHConnectionInfo.PWDialog"), (String)str);
    }

    public boolean promptPassphrase(String message) {
        PasswordDialog dlg = new PasswordDialog(Display.getCurrent().getActiveShell(), Messages.getString("SSHConnectionInfo.PWDialog"), message, null, null);
        int result = dlg.open();
        if (result == 0) {
            this.passphrase = dlg.getValue();
        } else {
            this.canceledPWValue = true;
        }
        return result == 0;
    }

    public boolean promptPassword(String message) {
        boolean ret = false;
        if (this.promptPasswd == 0) {
            ret = true;
        } else {
            PasswordDialog dlg;
            int result;
            if (1 < this.promptPasswd) {
                --this.promptPasswd;
                MessageDialog.openError(null, (String)Messages.getString("SSHConnectionInfo.error_wrongPW_title"), (String)Messages.getString("SSHConnectionInfo.error_wrongPW_msg"));
            }
            if ((result = (dlg = new PasswordDialog(Display.getCurrent().getActiveShell(), Messages.getString("SSHConnectionInfo.PWDialog"), message, null, null)).open()) == 0) {
                this.passwd = dlg.getValue();
                PasswordManager.registerPassword((String)(String.valueOf(this.user) + '@' + this.host), (String)this.passwd);
            } else {
                this.canceledPWValue = true;
            }
            ret = result == 0;
        }
        return ret;
    }

    public void showMessage(String message) {
        MessageDialog.openInformation(null, (String)Messages.getString("SSHConnectionInfo.PWDialog"), (String)message);
    }

    public boolean getCanceledPWValue() {
        return this.canceledPWValue;
    }
}

