/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal;

import eu.geclipse.batch.IBatchService;
import eu.geclipse.batch.IWorkerNodeInfo;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.model.WorkerNode;
import eu.geclipse.batch.ui.internal.parts.BatchTreeEditPart;
import eu.geclipse.batch.ui.internal.parts.WorkerNodeEditPart;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class WorkerNodeAction
extends SelectionAction {
    public static final String PROPERTY_WN_ACTION_CHANGESTATUS = "WorkerNodeAction.ChangeStatus";
    private IBatchService batchWrapper;
    private boolean enable;
    private ImageDescriptor imgEnable;

    public WorkerNodeAction(IWorkbenchPart part, IBatchService batchWrapper) {
        super(part);
        this.batchWrapper = batchWrapper;
        this.setId(PROPERTY_WN_ACTION_CHANGESTATUS);
        this.setToolTipText(Messages.getString("WorkerNodeAction.Msg.ChangeStatusTips"));
        this.imgEnable = Activator.getDefault().getImageRegistry().getDescriptor("enableResource");
    }

    public void run() {
        for (Object o : this.getSelectedObjects()) {
            WorkerNode wn;
            if (o instanceof BatchTreeEditPart) {
                BatchTreeEditPart treeEditPart = (BatchTreeEditPart)o;
                wn = (WorkerNode)treeEditPart.getModel();
            } else {
                if (!(o instanceof WorkerNodeEditPart)) break;
                WorkerNodeEditPart wnEdit = (WorkerNodeEditPart)o;
                wn = (WorkerNode)wnEdit.getModel();
            }
            String strName = wn.getFQDN();
            try {
                if (this.enable) {
                    this.batchWrapper.enableWN(strName);
                    continue;
                }
                this.batchWrapper.disableWN(strName);
            }
            catch (ProblemException excp) {
                ProblemDialog.openProblem((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.getString("WorkerNodeAction.error_manipulate_title"), (String)Messages.getString("WorkerNodeAction.error_manipulate_message"), (Throwable)excp);
            }
        }
    }

    protected boolean calculateEnabled() {
        boolean result;
        boolean firstTime = true;
        boolean enableAll = true;
        WorkerNode wn = null;
        boolean bl = result = !this.getSelectedObjects().isEmpty();
        if (result) {
            for (Object o : this.getSelectedObjects()) {
                if (o instanceof BatchTreeEditPart) {
                    BatchTreeEditPart treeEditPart = (BatchTreeEditPart)o;
                    Object oModel = treeEditPart.getModel();
                    if (!(oModel instanceof WorkerNode)) {
                        result = false;
                        break;
                    }
                    wn = (WorkerNode)oModel;
                } else if (o instanceof WorkerNodeEditPart) {
                    WorkerNodeEditPart wnEdit = (WorkerNodeEditPart)o;
                    wn = (WorkerNode)wnEdit.getModel();
                } else {
                    result = false;
                    break;
                }
                if (firstTime) {
                    if (wn.getState() == IWorkerNodeInfo.WorkerNodeState.free || wn.getState() == IWorkerNodeInfo.WorkerNodeState.job_exclusive || wn.getState() == IWorkerNodeInfo.WorkerNodeState.busy) {
                        enableAll = false;
                    }
                    firstTime = false;
                    continue;
                }
                if ((!enableAll || wn.getState() != IWorkerNodeInfo.WorkerNodeState.free && wn.getState() != IWorkerNodeInfo.WorkerNodeState.job_exclusive && wn.getState() != IWorkerNodeInfo.WorkerNodeState.busy) && (enableAll || wn.getState() != IWorkerNodeInfo.WorkerNodeState.down && wn.getState() != IWorkerNodeInfo.WorkerNodeState.offline)) continue;
                result = false;
                break;
            }
            if (enableAll) {
                this.setText(Messages.getString("WorkerNodeAction.Msg.EnableText"));
                this.setImageDescriptor(this.imgEnable);
                this.enable = true;
            } else {
                this.setText(Messages.getString("WorkerNodeAction.Msg.DisableText"));
                this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
                this.enable = false;
            }
        }
        return result;
    }
}

