/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.adapters;

import eu.geclipse.batch.model.qdl.IntegerBoundaryType;
import eu.geclipse.batch.model.qdl.IntegerExactType;
import eu.geclipse.batch.model.qdl.IntegerRangeValueType;
import eu.geclipse.batch.model.qdl.QdlFactory;
import eu.geclipse.batch.model.qdl.QueueType;
import eu.geclipse.batch.ui.internal.adapters.QdlAdaptersFactory;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Spinner;

public class AdvancedQueueAdapter
extends QdlAdaptersFactory {
    protected HashMap<Integer, Spinner> spinnerWidgetMap = new HashMap();
    protected HashMap<Integer, Button> buttonWidgetMap = new HashMap();
    protected QueueType queue = QdlFactory.eINSTANCE.createQueueType();
    private boolean adapterRefreshed = false;
    private boolean isNotifyAllowed = true;

    public AdvancedQueueAdapter(QueueType queue) {
        this.getTypeForAdapter(queue);
    }

    protected void contentChanged() {
        if (this.isNotifyAllowed) {
            this.fireNotifyChanged(null);
        }
    }

    public void setContent(QueueType q) {
        this.getTypeForAdapter(q);
    }

    private void getTypeForAdapter(QueueType q) {
        this.queue = q;
    }

    protected EObject checkProxy(EObject refEObject) {
        EObject eObject = refEObject;
        if (eObject != null && eObject.eIsProxy()) {
            eObject = EcoreUtil.resolve((EObject)eObject, (EObject)this.queue);
        }
        return eObject;
    }

    public void attachPrioritySpinner(final Spinner spinner) {
        Integer featureID = 8;
        this.spinnerWidgetMap.put(featureID, spinner);
        spinner.addModifyListener(new ModifyListener(){
            IntegerRangeValueType integerRangeValueType = QdlFactory.eINSTANCE.createIntegerRangeValueType();
            IntegerBoundaryType integerBoundaryType = QdlFactory.eINSTANCE.createIntegerBoundaryType();

            public void modifyText(ModifyEvent e) {
                this.integerBoundaryType.setValue(Integer.valueOf(spinner.getSelection()).intValue());
                this.integerBoundaryType = (IntegerBoundaryType)AdvancedQueueAdapter.this.checkProxy((EObject)this.integerBoundaryType);
                this.integerRangeValueType = (IntegerRangeValueType)AdvancedQueueAdapter.this.checkProxy((EObject)this.integerRangeValueType);
                this.integerRangeValueType.setUpperBoundedRange(this.integerBoundaryType);
                AdvancedQueueAdapter.this.queue.setPriority(this.integerRangeValueType);
                AdvancedQueueAdapter.this.contentChanged();
            }
        });
    }

    public void attachRunningJobsSpinner(final Spinner spinner, Button button) {
        Integer featureID = 9;
        this.spinnerWidgetMap.put(featureID, spinner);
        this.buttonWidgetMap.put(featureID, button);
        spinner.addModifyListener(new ModifyListener(){
            IntegerRangeValueType integerRangeValueTupe = QdlFactory.eINSTANCE.createIntegerRangeValueType();
            IntegerBoundaryType integerBoundaryType = QdlFactory.eINSTANCE.createIntegerBoundaryType();

            public void modifyText(ModifyEvent e) {
                this.integerBoundaryType.setValue(Integer.valueOf(spinner.getSelection()).intValue());
                this.integerBoundaryType = (IntegerBoundaryType)AdvancedQueueAdapter.this.checkProxy((EObject)this.integerBoundaryType);
                this.integerRangeValueTupe = (IntegerRangeValueType)AdvancedQueueAdapter.this.checkProxy((EObject)this.integerRangeValueTupe);
                this.integerRangeValueTupe.setUpperBoundedRange(this.integerBoundaryType);
                AdvancedQueueAdapter.this.queue.setRunningJobs(this.integerRangeValueTupe);
                AdvancedQueueAdapter.this.contentChanged();
            }
        });
    }

    public void attachJobsInQueueSpinner(final Spinner spinner, Button button) {
        Integer featureID = 10;
        this.spinnerWidgetMap.put(featureID, spinner);
        this.buttonWidgetMap.put(featureID, button);
        spinner.addModifyListener(new ModifyListener(){
            IntegerRangeValueType integerRangeValueTupe = QdlFactory.eINSTANCE.createIntegerRangeValueType();
            IntegerBoundaryType boundaryType = QdlFactory.eINSTANCE.createIntegerBoundaryType();

            public void modifyText(ModifyEvent e) {
                this.boundaryType.setValue(Integer.valueOf(spinner.getSelection()).intValue());
                this.boundaryType = (IntegerBoundaryType)AdvancedQueueAdapter.this.checkProxy((EObject)this.boundaryType);
                this.integerRangeValueTupe = (IntegerRangeValueType)AdvancedQueueAdapter.this.checkProxy((EObject)this.integerRangeValueTupe);
                this.integerRangeValueTupe.setUpperBoundedRange(this.boundaryType);
                AdvancedQueueAdapter.this.queue.setJobsInQueue(this.integerRangeValueTupe);
                AdvancedQueueAdapter.this.contentChanged();
            }
        });
    }

    public void attachAssignedResourcesSpinner(final Spinner spinner) {
        Integer featureID = 11;
        this.spinnerWidgetMap.put(featureID, spinner);
        spinner.addModifyListener(new ModifyListener(){
            IntegerRangeValueType integerRangeValueTupe = QdlFactory.eINSTANCE.createIntegerRangeValueType();
            IntegerExactType exactType = QdlFactory.eINSTANCE.createIntegerExactType();

            public void modifyText(ModifyEvent e) {
                this.exactType.setValue(Integer.valueOf(spinner.getSelection()).intValue());
                this.exactType = (IntegerExactType)AdvancedQueueAdapter.this.checkProxy((EObject)this.exactType);
                this.integerRangeValueTupe = (IntegerRangeValueType)AdvancedQueueAdapter.this.checkProxy((EObject)this.integerRangeValueTupe);
                this.integerRangeValueTupe.getExact().add((Object)this.exactType);
                AdvancedQueueAdapter.this.queue.setAssignedResources(this.integerRangeValueTupe);
                AdvancedQueueAdapter.this.contentChanged();
            }
        });
    }

    public void setUnlimitedRunningJobs() {
        IntegerRangeValueType integerRangeValueTupe = QdlFactory.eINSTANCE.createIntegerRangeValueType();
        IntegerBoundaryType integerBoundaryType = QdlFactory.eINSTANCE.createIntegerBoundaryType();
        integerBoundaryType.setValue(Integer.valueOf(Integer.MAX_VALUE).intValue());
        integerBoundaryType = (IntegerBoundaryType)this.checkProxy((EObject)integerBoundaryType);
        integerRangeValueTupe = (IntegerRangeValueType)this.checkProxy((EObject)integerRangeValueTupe);
        integerRangeValueTupe.setUpperBoundedRange(integerBoundaryType);
        this.queue.setRunningJobs(integerRangeValueTupe);
        this.contentChanged();
    }

    public void setUnlimitedJobsInQueue() {
        IntegerRangeValueType integerRangeValueType = QdlFactory.eINSTANCE.createIntegerRangeValueType();
        IntegerBoundaryType integerBoundaryType = QdlFactory.eINSTANCE.createIntegerBoundaryType();
        integerBoundaryType.setValue(Integer.valueOf(Integer.MAX_VALUE).intValue());
        integerBoundaryType = (IntegerBoundaryType)this.checkProxy((EObject)integerBoundaryType);
        integerRangeValueType = (IntegerRangeValueType)this.checkProxy((EObject)integerRangeValueType);
        integerRangeValueType.setUpperBoundedRange(integerBoundaryType);
        this.queue.setJobsInQueue(integerRangeValueType);
        this.contentChanged();
    }

    public void load() {
        this.isNotifyAllowed = false;
        Spinner spinner = null;
        Button button = null;
        IntegerBoundaryType integerBoundaryType = null;
        IntegerExactType integerExactType = null;
        IntegerRangeValueType integerRangeValueType = null;
        if (this.queue != null) {
            EClass eClass = this.queue.eClass();
            EList eAllStructuralFeaures = eClass.getEAllStructuralFeatures();
            for (EStructuralFeature eStructuralFeature : eAllStructuralFeaures) {
                int featureID = eStructuralFeature.getFeatureID();
                if (!this.queue.eIsSet(eStructuralFeature) || !(eStructuralFeature instanceof EReference)) continue;
                switch (featureID) {
                    case 8: {
                        if (this.queue.getCPUTimeLimit() == null) break;
                        spinner = this.spinnerWidgetMap.get(8);
                        integerRangeValueType = this.queue.getPriority();
                        integerBoundaryType = integerRangeValueType.getUpperBoundedRange() != null ? integerRangeValueType.getUpperBoundedRange() : integerRangeValueType.getLowerBoundedRange();
                        spinner.setSelection(integerBoundaryType.getValue());
                        break;
                    }
                    case 9: {
                        if (this.queue.getCPUTimeLimit() == null) break;
                        spinner = this.spinnerWidgetMap.get(9);
                        button = this.buttonWidgetMap.get(9);
                        integerRangeValueType = this.queue.getRunningJobs();
                        integerBoundaryType = integerRangeValueType.getUpperBoundedRange() != null ? integerRangeValueType.getUpperBoundedRange() : integerRangeValueType.getLowerBoundedRange();
                        int value = integerBoundaryType.getValue();
                        spinner.setSelection(value);
                        if (value != Integer.MAX_VALUE) break;
                        spinner.setEnabled(false);
                        button.setSelection(true);
                        break;
                    }
                    case 10: {
                        if (this.queue.getCPUTimeLimit() == null) break;
                        spinner = this.spinnerWidgetMap.get(10);
                        button = this.buttonWidgetMap.get(10);
                        integerRangeValueType = this.queue.getJobsInQueue();
                        integerBoundaryType = integerRangeValueType.getUpperBoundedRange() != null ? integerRangeValueType.getUpperBoundedRange() : integerRangeValueType.getLowerBoundedRange();
                        int value = integerBoundaryType.getValue();
                        spinner.setSelection(value);
                        if (value != Integer.MAX_VALUE) break;
                        spinner.setEnabled(false);
                        button.setSelection(true);
                        break;
                    }
                    case 11: {
                        if (this.queue.getCPUTimeLimit() == null) break;
                        spinner = this.spinnerWidgetMap.get(11);
                        integerRangeValueType = this.queue.getAssignedResources();
                        if (integerRangeValueType.getUpperBoundedRange() != null) {
                            integerBoundaryType = integerRangeValueType.getUpperBoundedRange();
                            spinner.setSelection(integerBoundaryType.getValue());
                        } else if (integerRangeValueType.getLowerBoundedRange() != null) {
                            integerBoundaryType = integerRangeValueType.getLowerBoundedRange();
                            spinner.setSelection(integerBoundaryType.getValue());
                        } else {
                            integerExactType = (IntegerExactType)integerRangeValueType.getExact().get(0);
                        }
                        if (integerExactType == null) break;
                        spinner.setSelection(integerExactType.getValue());
                        break;
                    }
                }
            }
        }
        this.isNotifyAllowed = true;
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
    }
}

