/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.adapters;

import eu.geclipse.batch.model.qdl.AllowedVirtualOrganizationsType;
import eu.geclipse.batch.model.qdl.BoundaryType;
import eu.geclipse.batch.model.qdl.QdlFactory;
import eu.geclipse.batch.model.qdl.QdlPackage;
import eu.geclipse.batch.model.qdl.QueueStatusEnumeration;
import eu.geclipse.batch.model.qdl.QueueType;
import eu.geclipse.batch.model.qdl.QueueTypeEnumeration;
import eu.geclipse.batch.model.qdl.RangeValueType;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.adapters.QdlAdaptersFactory;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class QueueAdapter
extends QdlAdaptersFactory {
    protected HashMap<Integer, Text> textWidgetMap = new HashMap();
    protected HashMap<Integer, Combo> comboWidgetMap = new HashMap();
    protected HashMap<Integer, TableViewer> viewerWidgetMap = new HashMap();
    protected HashMap<Integer, Spinner> spinnerWidgetMap = new HashMap();
    protected AllowedVirtualOrganizationsType allowedVOs = QdlFactory.eINSTANCE.createAllowedVirtualOrganizationsType();
    protected QueueType queue = QdlFactory.eINSTANCE.createQueueType();
    private boolean adapterRefreshed = false;
    private boolean isNotifyAllowed = true;

    public QueueAdapter(QueueType queue) {
        this.getTypeForAdapter(queue);
    }

    protected void contentChanged() {
        if (this.isNotifyAllowed) {
            this.fireNotifyChanged(null);
        }
    }

    public void setContent(QueueType q) {
        this.getTypeForAdapter(q);
    }

    private void getTypeForAdapter(QueueType q) {
        this.queue = q;
    }

    protected EObject checkProxy(EObject refEObject) {
        EObject eObject = refEObject;
        if (eObject != null && eObject.eIsProxy()) {
            eObject = EcoreUtil.resolve((EObject)eObject, (EObject)this.queue);
        }
        return eObject;
    }

    public void attachQueueName(final Text text) {
        Integer featureID = 0;
        this.textWidgetMap.put(featureID, text);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QueueAdapter.this.queue.setQueueName(text.getText());
                QueueAdapter.this.contentChanged();
            }
        });
    }

    public void attachQueueDescription(final Text text) {
        Integer featureID = 1;
        this.textWidgetMap.put(featureID, text);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QueueAdapter.this.queue.setDescription(text.getText());
                QueueAdapter.this.contentChanged();
            }
        });
    }

    public void attachQueueType(final Combo combo) {
        Integer featureID = 2;
        this.comboWidgetMap.put(featureID, combo);
        EEnum cFEnum = QdlPackage.Literals.QUEUE_TYPE_ENUMERATION;
        int i = 0;
        while (i < cFEnum.getELiterals().size()) {
            combo.add(cFEnum.getEEnumLiteral(i).toString());
            ++i;
        }
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String selection = combo.getItem(combo.getSelectionIndex());
                QueueAdapter.this.queue.setQueueType(QueueTypeEnumeration.get((String)selection));
                QueueAdapter.this.contentChanged();
            }
        });
    }

    public void attachQueueStatus(final Combo combo) {
        Integer featureID = 3;
        this.comboWidgetMap.put(featureID, combo);
        EEnum cFEnum = QdlPackage.Literals.QUEUE_STATUS_ENUMERATION;
        int i = 0;
        while (i < cFEnum.getELiterals().size()) {
            combo.add(cFEnum.getEEnumLiteral(i).toString());
            ++i;
        }
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String selection = combo.getItem(combo.getSelectionIndex());
                QueueAdapter.this.queue.setQueueStatus(QueueStatusEnumeration.get((String)selection));
                QueueAdapter.this.contentChanged();
            }
        });
    }

    public void attachQueueStarted(final Combo combo) {
        Integer featureID = 4;
        this.comboWidgetMap.put(featureID, combo);
        combo.add("true");
        combo.add("false");
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                QueueAdapter.this.queue.setQueueStarted(Boolean.parseBoolean(combo.getText()));
                QueueAdapter.this.contentChanged();
            }
        });
    }

    public void attachMaxCPUTimeSpinner(final Spinner spinner) {
        Integer featureID = 5;
        this.spinnerWidgetMap.put(featureID, spinner);
        spinner.addModifyListener(new ModifyListener(){
            RangeValueType rangeValueType = QdlFactory.eINSTANCE.createRangeValueType();
            BoundaryType boundaryType = QdlFactory.eINSTANCE.createBoundaryType();

            public void modifyText(ModifyEvent e) {
                this.boundaryType.setValue((double)spinner.getSelection());
                this.boundaryType = (BoundaryType)QueueAdapter.this.checkProxy((EObject)this.boundaryType);
                this.rangeValueType = (RangeValueType)QueueAdapter.this.checkProxy((EObject)this.rangeValueType);
                this.rangeValueType.setUpperBoundedRange(this.boundaryType);
                QueueAdapter.this.queue.setCPUTimeLimit(this.rangeValueType);
                QueueAdapter.this.contentChanged();
            }
        });
    }

    public void attachMaxWallTimeSpinner(final Spinner spinner) {
        Integer featureID = 6;
        this.spinnerWidgetMap.put(featureID, spinner);
        spinner.addModifyListener(new ModifyListener(){
            RangeValueType rangeValueType = QdlFactory.eINSTANCE.createRangeValueType();
            BoundaryType boundaryType = QdlFactory.eINSTANCE.createBoundaryType();

            public void modifyText(ModifyEvent e) {
                this.boundaryType.setValue((double)spinner.getSelection());
                this.boundaryType = (BoundaryType)QueueAdapter.this.checkProxy((EObject)this.boundaryType);
                this.rangeValueType = (RangeValueType)QueueAdapter.this.checkProxy((EObject)this.rangeValueType);
                this.rangeValueType.setUpperBoundedRange(this.boundaryType);
                QueueAdapter.this.queue.setWallTimeLimit(this.rangeValueType);
                QueueAdapter.this.contentChanged();
            }
        });
    }

    public void attachAllowedVOs(TableViewer tableViewer) {
        Integer featureID = 7;
        this.viewerWidgetMap.put(featureID, tableViewer);
    }

    public void addAllowedVO(TableViewer tableViewer, Object value) {
        if (value == null) {
            return;
        }
        ArrayList<String> collection = new ArrayList<String>();
        EList newInputList = (EList)tableViewer.getInput();
        if (newInputList == null) {
            newInputList = new BasicEList();
        }
        newInputList.add((Object)((String)value));
        tableViewer.setInput((Object)newInputList);
        int i = 0;
        while (i < tableViewer.getTable().getItemCount()) {
            collection.add((String)tableViewer.getElementAt(i));
            ++i;
        }
        this.allowedVOs.getVOName().clear();
        this.allowedVOs.getVOName().addAll(collection);
        if (this.queue.getAllowedVirtualOrganizations() == null) {
            this.queue.setAllowedVirtualOrganizations(this.allowedVOs);
        }
        this.contentChanged();
        collection = null;
    }

    public void editAllowedVO(TableViewer tableViewer, Object value) {
        if (value == null) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)tableViewer.getSelection();
        if (structSelection != null) {
            Object feature = structSelection.getFirstElement();
            int idx = this.allowedVOs.getVOName().indexOf(feature);
            try {
                this.allowedVOs.getVOName().set(idx, (Object)value.toString());
            }
            catch (Exception e) {
                Activator.logException(e);
            }
            tableViewer.refresh();
            this.contentChanged();
        }
    }

    public void deleteAllowedVo(TableViewer tableViewer) {
        IStructuredSelection structSelection = (IStructuredSelection)tableViewer.getSelection();
        if (structSelection != null) {
            for (Object feature : structSelection) {
                try {
                    if (!this.adapterRefreshed) {
                        this.allowedVOs.getVOName().remove(feature);
                        if (this.allowedVOs.getVOName().size() == 0) {
                            EcoreUtil.remove((EObject)this.allowedVOs);
                        }
                        this.contentChanged();
                    } else {
                        tableViewer.remove(feature);
                    }
                }
                catch (Exception e) {
                    Activator.logException(e);
                }
                tableViewer.refresh();
            }
        }
    }

    public void load() {
        this.isNotifyAllowed = false;
        Text text = null;
        Combo combo = null;
        Spinner spinner = null;
        TableViewer tableViewer = null;
        BoundaryType boundaryType = null;
        RangeValueType rangeValueType = null;
        if (this.queue != null) {
            EClass eClass = this.queue.eClass();
            EList eAllStructuralFeaures = eClass.getEAllStructuralFeatures();
            block12: for (EStructuralFeature eStructuralFeature : eAllStructuralFeaures) {
                int featureID = eStructuralFeature.getFeatureID();
                if (!this.queue.eIsSet(eStructuralFeature)) continue;
                if (eStructuralFeature instanceof EReference) {
                    switch (featureID) {
                        case 7: {
                            tableViewer = this.viewerWidgetMap.get(featureID);
                            this.allowedVOs = (AllowedVirtualOrganizationsType)this.queue.eGet(eStructuralFeature);
                            EList valueEList = this.allowedVOs.getVOName();
                            tableViewer.setInput((Object)valueEList);
                            break;
                        }
                        case 5: {
                            if (this.queue.getCPUTimeLimit() == null) continue block12;
                            spinner = this.spinnerWidgetMap.get(5);
                            rangeValueType = this.queue.getCPUTimeLimit();
                            boundaryType = rangeValueType.getUpperBoundedRange() != null ? rangeValueType.getUpperBoundedRange() : rangeValueType.getLowerBoundedRange();
                            spinner.setSelection((int)boundaryType.getValue());
                            break;
                        }
                        case 6: {
                            if (this.queue.getCPUTimeLimit() == null) continue block12;
                            spinner = this.spinnerWidgetMap.get(new Integer(6));
                            rangeValueType = this.queue.getWallTimeLimit();
                            boundaryType = rangeValueType.getUpperBoundedRange() != null ? rangeValueType.getUpperBoundedRange() : rangeValueType.getLowerBoundedRange();
                            spinner.setSelection((int)boundaryType.getValue());
                            break;
                        }
                    }
                    continue;
                }
                switch (featureID) {
                    case 0: {
                        if (this.queue.getQueueName() == null) break;
                        text = this.textWidgetMap.get(new Integer(0));
                        text.setText(this.queue.getQueueName());
                        break;
                    }
                    case 1: {
                        if (this.queue.getDescription() == null) break;
                        text = this.textWidgetMap.get(new Integer(1));
                        text.setText(this.queue.getDescription());
                        break;
                    }
                    case 3: {
                        if (this.queue.getQueueStatus() == null) break;
                        combo = this.comboWidgetMap.get(new Integer(3));
                        combo.setText(this.queue.getQueueStatus().getLiteral());
                        break;
                    }
                    case 4: {
                        combo = this.comboWidgetMap.get(new Integer(4));
                        combo.setText(Boolean.toString(this.queue.isQueueStarted()));
                        break;
                    }
                    case 2: {
                        if (this.queue.getQueueType() == null) break;
                        combo = this.comboWidgetMap.get(new Integer(2));
                        combo.setText(this.queue.getQueueType().getLiteral());
                        break;
                    }
                }
            }
        }
        this.isNotifyAllowed = true;
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
    }
}

