/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.model;

import eu.geclipse.batch.ui.internal.BatchJobManager;
import eu.geclipse.batch.ui.internal.model.Connection;
import eu.geclipse.batch.ui.internal.model.ModelElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchResource
extends ModelElement
implements Comparable {
    public static final String LOCATION_PROP = "BatchResource.Location";
    public static final String SIZE_PROP = "BatchResource.Size";
    public static final String SOURCE_CONNECTIONS_PROP = "BatchResource.SourceConn";
    public static final String TARGET_CONNECTIONS_PROP = "BatchResource.TargetConn";
    private static final long serialVersionUID = 1L;
    protected BatchJobManager jobManager;
    private Point location = new Point(0, 0);
    private Dimension size = new Dimension(50, 50);
    private List<Connection> sourceConnections = new ArrayList<Connection>();
    private List<Connection> targetConnections = new ArrayList<Connection>();

    public BatchResource(BatchJobManager jobManager) {
        this.jobManager = jobManager;
    }

    public void addConnection(Connection conn) {
        if (conn == null || conn.getSource() == conn.getTarget()) {
            throw new IllegalArgumentException();
        }
        if (this == conn.getSource()) {
            this.sourceConnections.add(conn);
            this.firePropertyChange(SOURCE_CONNECTIONS_PROP, null, conn);
        } else if (this == conn.getTarget()) {
            this.targetConnections.add(conn);
            this.firePropertyChange(TARGET_CONNECTIONS_PROP, null, conn);
        }
    }

    public abstract Image getIcon();

    public Point getLocation() {
        return this.location.getCopy();
    }

    public Dimension getSize() {
        return this.size.getCopy();
    }

    public List<Connection> getSourceConnections() {
        return new ArrayList<Connection>(this.sourceConnections);
    }

    public List<Connection> getTargetConnections() {
        return new ArrayList<Connection>(this.targetConnections);
    }

    public void removeConnection(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (this == conn.getSource()) {
            this.sourceConnections.remove(conn);
            this.firePropertyChange(SOURCE_CONNECTIONS_PROP, null, conn);
        } else if (this == conn.getTarget()) {
            this.targetConnections.remove(conn);
            this.firePropertyChange(TARGET_CONNECTIONS_PROP, null, conn);
        }
    }

    public void setLocation(Point newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException();
        }
        this.location.setLocation(newLocation);
        this.firePropertyChange(LOCATION_PROP, null, this.location);
    }

    public void setSize(Dimension newSize) {
        if (newSize != null) {
            this.size.setSize(newSize);
            this.firePropertyChange(SIZE_PROP, null, this.size);
        }
    }

    public BatchJobManager getJobManager() {
        return this.jobManager;
    }

    public abstract String getOutlineString();
}

