/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.model;

import eu.geclipse.batch.IBatchJobInfo;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.BatchJobManager;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.model.BatchResource;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputingElement
extends BatchResource {
    public static final String PROPERTY_FQDN = "ComputingElement.fqdn";
    public static final String PROPERTY_TYPE = "ComputingElement.type";
    public static final String PROPERTY_NUM_WN = "ComputingElement.num_wn";
    public static final String PROPERTY_NUM_QUEUE = "ComputingElement.num_queue";
    public static final String PROPERTY_NUM_JOBS = "ComputingElement.num_jobs";
    private static final long serialVersionUID = 1L;
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"ComputingElement.fqdn", Messages.getString("ComputingElement.Fqdn")), new PropertyDescriptor((Object)"ComputingElement.type", Messages.getString("ComputingElementFigure.ServiceType")), new PropertyDescriptor((Object)"ComputingElement.num_wn", Messages.getString("ComputingElementFigure.NumOfWns")), new PropertyDescriptor((Object)"ComputingElement.num_queue", Messages.getString("ComputingElementFigure.NumOfQueues")), new PropertyDescriptor((Object)"ComputingElement.num_jobs", Messages.getString("ComputingElementFigure.NumOfJobs"))};
    private final Image computingElementIcon = Activator.getDefault().getImageRegistry().get("computingElementIcon");
    private String fqdn;
    private String type;
    private int numWn;
    private int numQueue;
    private int numJobs;

    static {
        int i = 0;
        while (i < descriptors.length) {
            ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    int intValue = -1;
                    String str = null;
                    try {
                        intValue = Integer.parseInt((String)value);
                        str = intValue >= 0 ? null : Messages.getString("WorkerNode.Error.LTZero");
                    }
                    catch (NumberFormatException numberFormatException) {
                        str = Messages.getString("WorkerNode.Error.NotANumber");
                    }
                    return str;
                }
            });
            ++i;
        }
    }

    public ComputingElement(BatchJobManager jobManager) {
        super(jobManager);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        Object str = null;
        if (PROPERTY_FQDN.equals(propertyId)) {
            str = this.fqdn;
        } else if (PROPERTY_TYPE.equals(propertyId)) {
            str = this.type;
        } else if (PROPERTY_NUM_WN.equals(propertyId)) {
            str = Integer.toString(this.numWn);
        } else if (PROPERTY_NUM_QUEUE.equals(propertyId)) {
            str = Integer.toString(this.numQueue);
        } else if (PROPERTY_NUM_JOBS.equals(propertyId)) {
            str = Integer.toString(this.numJobs);
        }
        if (str == null) {
            str = super.getPropertyValue(propertyId);
        }
        return str;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.removePropertyChangeListener(listener);
    }

    public void setFQDN(String newName) {
        String oldName = this.fqdn;
        this.fqdn = newName;
        this.pcsDelegate.firePropertyChange(PROPERTY_FQDN, oldName, newName);
    }

    public void setType(String newType) {
        String oldType = this.type;
        this.type = newType;
        this.pcsDelegate.firePropertyChange(PROPERTY_TYPE, oldType, newType);
    }

    public void setNumWNs(int newNumWn) {
        int oldNumWn = this.numWn;
        this.numWn = newNumWn;
        this.pcsDelegate.firePropertyChange(PROPERTY_NUM_WN, oldNumWn, newNumWn);
    }

    public void setNumQueues(int newNumQueue) {
        int oldNumQueue = this.numQueue;
        this.numQueue = newNumQueue;
        this.pcsDelegate.firePropertyChange(PROPERTY_NUM_QUEUE, oldNumQueue, newNumQueue);
    }

    public void setNumJobs(int newNumJobs) {
        int oldNumJobs = this.numJobs;
        this.numJobs = newNumJobs;
        this.pcsDelegate.firePropertyChange(PROPERTY_NUM_JOBS, oldNumJobs, newNumJobs);
    }

    public String getFQDN() {
        return this.fqdn;
    }

    public String getType() {
        return this.type;
    }

    public int getNumWNs() {
        return this.numWn;
    }

    public int getNumQueues() {
        return this.numQueue;
    }

    public int getNumJobs() {
        return this.numJobs;
    }

    public List<IBatchJobInfo> getJobs() {
        return this.jobManager.getJobs();
    }

    @Override
    public Image getIcon() {
        return this.computingElementIcon;
    }

    @Override
    public String getOutlineString() {
        return String.valueOf(Messages.getString("ComputingElement.CE")) + this.fqdn;
    }

    public int compareTo(Object o) {
        return 0;
    }
}

