/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.model;

import eu.geclipse.batch.ui.internal.model.BatchResource;
import eu.geclipse.batch.ui.internal.model.ModelElement;

public class Connection
extends ModelElement {
    public static final int SOLID_CONNECTION = 1;
    public static final int DASHED_CONNECTION = 2;
    public static final String LINESTYLE_PROP = "LineStyle";
    private static final long serialVersionUID = 1L;
    private boolean isConnected;
    private int lineStyle;
    private BatchResource source;
    private BatchResource target;

    public Connection(BatchResource source, BatchResource target, int lineStyle) {
        this.lineStyle = lineStyle;
        this.source = source;
        this.target = target;
    }

    public void disconnect() {
        if (this.isConnected) {
            this.source.removeConnection(this);
            this.target.removeConnection(this);
            this.isConnected = false;
        }
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public BatchResource getSource() {
        return this.source;
    }

    public BatchResource getTarget() {
        return this.target;
    }

    public void reconnect() {
        if (!this.isConnected) {
            this.source.addConnection(this);
            this.target.addConnection(this);
            this.isConnected = true;
        }
    }

    public void reconnect(BatchResource newSource, BatchResource newTarget) {
        if (newSource == null || newTarget == null || newSource == newTarget) {
            throw new IllegalArgumentException();
        }
        this.disconnect();
        this.source = newSource;
        this.target = newTarget;
        this.reconnect();
    }

    public int compareTo(Object o) {
        return 0;
    }
}

