/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.pages;

import eu.geclipse.batch.model.qdl.QueueType;
import eu.geclipse.batch.ui.editors.QueueEditor;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.adapters.AdvancedQueueAdapter;
import eu.geclipse.batch.ui.internal.pages.FormLayoutFactory;
import eu.geclipse.batch.ui.internal.pages.FormSectionFactory;
import java.net.URL;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class AdvancedQueueConfigPage
extends FormPage
implements INotifyChangedListener {
    protected static final String PAGE_ID = "ADVANCED_PAGE";
    protected Composite composite = null;
    protected Composite body = null;
    protected Label lblPriority = null;
    protected Label lblJobsinQueue;
    protected Label lblMaxJobs;
    protected Label lblAssignedResources = null;
    protected Spinner prioritySpin;
    protected Spinner maxJobsSpin;
    protected Spinner jobsInQueueSpin;
    protected Spinner resourcesSpin;
    protected Button btnUnlimitedRunningJobs = null;
    protected Button btnUnlimitedJobsInQueue = null;
    protected AdvancedQueueAdapter advancedQueueAdapter = null;
    private boolean contentRefreshed = false;
    private boolean dirtyFlag = false;
    private ImageDescriptor helpDesc = null;

    public AdvancedQueueConfigPage(QueueEditor editor) {
        super((FormEditor)editor, PAGE_ID, Messages.getString("AdvancedQueueConfigPage_TabTitle"));
    }

    public void setActive(boolean active) {
        if (active && this.isContentRefreshed()) {
            this.advancedQueueAdapter.load();
        }
    }

    public void setPageContent(QueueType queue, boolean refreshStatus) {
        if (refreshStatus) {
            this.contentRefreshed = true;
            this.advancedQueueAdapter.setContent(queue);
        } else {
            this.advancedQueueAdapter = new AdvancedQueueAdapter(queue);
            this.advancedQueueAdapter.addListener(this);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(Messages.getString("AdvancedQueueConfigPage_Title"));
        this.body = form.getBody();
        this.body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 1));
        this.composite = toolkit.createComposite(this.body);
        this.composite.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        this.composite.setLayoutData((Object)new TableWrapData(256));
        this.createAdvancedSection(this.composite, toolkit);
        this.advancedQueueAdapter.load();
        this.addFormPageHelp(form);
    }

    private void createAdvancedSection(Composite parent, FormToolkit toolkit) {
        String sectionTitle = Messages.getString("SimpleQueueConfigPage_AdvancedTitle");
        String sectionDescription = Messages.getString("AdvancedQueueConfigPage_Descr");
        Composite client = FormSectionFactory.createGridStaticSection(toolkit, parent, sectionTitle, sectionDescription, 3);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.lblPriority = toolkit.createLabel(client, Messages.getString("AdvancedQueueConfigPage_Priority"));
        Composite priorityComp = new Composite(client, 0);
        priorityComp.setLayout((Layout)new GridLayout(1, false));
        this.prioritySpin = new Spinner(priorityComp, 2048);
        this.prioritySpin.setValues(80, 0, Integer.MAX_VALUE, 0, 10, 10);
        this.advancedQueueAdapter.attachPrioritySpinner(this.prioritySpin);
        gd.horizontalSpan = 2;
        priorityComp.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.lblMaxJobs = toolkit.createLabel(client, Messages.getString("AdvancedQueueConfigPage_MaxRunningJobs"));
        Composite runningJobsComp = new Composite(client, 0);
        runningJobsComp.setLayout((Layout)new GridLayout(1, false));
        this.maxJobsSpin = new Spinner(runningJobsComp, 2048);
        this.maxJobsSpin.setValues(5, 0, Integer.MAX_VALUE, 0, 1, 1);
        gd.horizontalSpan = 1;
        runningJobsComp.setLayoutData((Object)gd);
        this.btnUnlimitedRunningJobs = new Button(client, 32);
        this.btnUnlimitedRunningJobs.setText(Messages.getString("AdvancedQueueConfigPage.Unlimited"));
        this.btnUnlimitedRunningJobs.setSelection(false);
        this.btnUnlimitedRunningJobs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedQueueConfigPage.this.maxJobsSpin.setEnabled(!AdvancedQueueConfigPage.this.btnUnlimitedRunningJobs.getSelection());
                AdvancedQueueConfigPage.this.advancedQueueAdapter.setUnlimitedRunningJobs();
            }
        });
        this.advancedQueueAdapter.attachRunningJobsSpinner(this.maxJobsSpin, this.btnUnlimitedRunningJobs);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.lblJobsinQueue = toolkit.createLabel(client, Messages.getString("AdvancedQueueConfigPage_MaxJobsInQueue"));
        Composite maxJobsComp = new Composite(client, 0);
        maxJobsComp.setLayout((Layout)new GridLayout(3, false));
        this.jobsInQueueSpin = new Spinner(maxJobsComp, 2048);
        this.jobsInQueueSpin.setValues(10, 0, Integer.MAX_VALUE, 0, 1, 1);
        gd.horizontalSpan = 1;
        maxJobsComp.setLayoutData((Object)gd);
        this.btnUnlimitedJobsInQueue = new Button(client, 32);
        this.btnUnlimitedJobsInQueue.setText(Messages.getString("AdvancedQueueConfigPage.Unlimited"));
        this.btnUnlimitedJobsInQueue.setSelection(false);
        this.btnUnlimitedJobsInQueue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedQueueConfigPage.this.jobsInQueueSpin.setEnabled(!AdvancedQueueConfigPage.this.btnUnlimitedJobsInQueue.getSelection());
                AdvancedQueueConfigPage.this.advancedQueueAdapter.setUnlimitedJobsInQueue();
            }
        });
        this.advancedQueueAdapter.attachJobsInQueueSpinner(this.jobsInQueueSpin, this.btnUnlimitedJobsInQueue);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.lblAssignedResources = toolkit.createLabel(client, Messages.getString("AdvancedQueueConfigPage_AssignedResources"));
        Composite resourcesComp = new Composite(client, 0);
        resourcesComp.setLayout((Layout)new GridLayout(3, false));
        this.resourcesSpin = new Spinner(resourcesComp, 2048);
        this.resourcesSpin.setValues(2, 1, 32000, 0, 1, 1);
        this.advancedQueueAdapter.attachAssignedResourcesSpinner(this.resourcesSpin);
        gd.horizontalSpan = 2;
        resourcesComp.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public void setDirty(boolean dirty) {
        if (this.dirtyFlag != dirty) {
            this.dirtyFlag = dirty;
            this.getEditor().editorDirtyStateChanged();
        }
    }

    private boolean isContentRefreshed() {
        return this.contentRefreshed;
    }

    public void notifyChanged(Notification notification) {
        this.setDirty(true);
    }

    protected void addFormPageHelp(final ScrolledForm form) {
        final String href = this.getHelpResource();
        if (href != null) {
            IToolBarManager manager = form.getToolBarManager();
            Action helpAction = new Action("help"){

                public void run() {
                    BusyIndicator.showWhile((Display)form.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
                        }
                    });
                }
            };
            helpAction.setToolTipText(Messages.getString("QdlEditorPage_HelpToolTip"));
            URL stageInURL = Activator.getDefault().getBundle().getEntry("icons/help.gif");
            this.helpDesc = ImageDescriptor.createFromURL((URL)stageInURL);
            helpAction.setImageDescriptor(this.helpDesc);
            manager.add((IAction)helpAction);
            form.updateToolBar();
        }
    }

    protected String getHelpResource() {
        return "/eu.geclipse.doc.user/html/concepts/siteadministration/editorpages/AdvancedParametersPage.html";
    }
}

