/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.pages;

import eu.geclipse.batch.model.qdl.QueueType;
import eu.geclipse.batch.ui.dialogs.AllowedVOsDialog;
import eu.geclipse.batch.ui.editors.QueueEditor;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.adapters.QueueAdapter;
import eu.geclipse.batch.ui.internal.pages.FormLayoutFactory;
import eu.geclipse.batch.ui.internal.pages.FormSectionFactory;
import eu.geclipse.batch.ui.internal.providers.QueueContentProvider;
import eu.geclipse.batch.ui.internal.providers.QueueLabelProvider;
import java.net.URL;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class SimpleQueueConfigPage
extends FormPage
implements INotifyChangedListener {
    protected static final String PAGE_ID = "SIMPLE_PAGE";
    protected Composite composite = null;
    protected Composite body = null;
    protected Label lblQueueName = null;
    protected Label lblQueueType = null;
    protected Label lblQueueStatus = null;
    protected Label lblQueueStarted = null;
    protected Label lblMaxCPUTime = null;
    protected Label lblMaxWallTime = null;
    protected Label lblVOS = null;
    protected Label lblDivider;
    protected Label lblQueueDescripiton = null;
    protected Text txtQueueName = null;
    protected Text txtQueueDescription = null;
    protected Combo cmbQueueType = null;
    protected Combo cmbQueueStatus = null;
    protected Combo cmbQueueStarted = null;
    protected Spinner timeCPUHourSpin = null;
    protected Spinner timeCPUMinSpin = null;
    protected Spinner timeWallHourSpin = null;
    protected Spinner timeWallMinSpin = null;
    protected Table tblAllowedVOs = null;
    protected TableViewer tableViewer = null;
    protected TableColumn column = null;
    protected Button btnAdd = null;
    protected Button btnEdit = null;
    protected Button btnDel = null;
    protected QueueAdapter queueAdapter = null;
    protected Object value = null;
    private ImageDescriptor helpDesc = null;
    private boolean contentRefreshed = false;
    private boolean dirtyFlag = false;
    private final int WIDGET_HEIGHT = 100;

    public SimpleQueueConfigPage(QueueEditor editor) {
        super((FormEditor)editor, PAGE_ID, Messages.getString("SimpleQueueConfigPage_TabTitle"));
    }

    public void setActive(boolean active) {
        if (active && this.isContentRefreshed()) {
            this.queueAdapter.load();
        }
    }

    public void setPageContent(QueueType queue, boolean refreshStatus) {
        if (refreshStatus) {
            this.contentRefreshed = true;
            this.queueAdapter.setContent(queue);
        } else {
            this.queueAdapter = new QueueAdapter(queue);
            this.queueAdapter.addListener(this);
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public void setDirty(boolean dirty) {
        if (this.dirtyFlag != dirty) {
            this.dirtyFlag = dirty;
            this.getEditor().editorDirtyStateChanged();
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(Messages.getString("SimpleQueueConfigPage_Title"));
        this.body = form.getBody();
        this.body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 1));
        this.composite = toolkit.createComposite(this.body);
        this.composite.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        this.composite.setLayoutData((Object)new TableWrapData(256));
        this.createSimpleSection(this.composite, toolkit);
        this.queueAdapter.load();
        this.addFormPageHelp(form);
    }

    private void createSimpleSection(Composite parent, FormToolkit toolkit) {
        String sectionTitle = Messages.getString("SimpleQueueConfigPage_RequiredTitle");
        String sectionDescription = Messages.getString("SimpleQueueConfigPage_RequiredDescr");
        Composite client = FormSectionFactory.createGridStaticSection(toolkit, parent, sectionTitle, sectionDescription, 4);
        this.lblQueueName = toolkit.createLabel(client, Messages.getString("SimpleQueueConfigPage_QueueName"));
        this.txtQueueName = toolkit.createText(client, "", 0);
        this.queueAdapter.attachQueueName(this.txtQueueName);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 2;
        gd.horizontalSpan = 3;
        gd.widthHint = 300;
        this.txtQueueName.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.verticalAlignment = 1;
        this.lblQueueDescripiton = toolkit.createLabel(client, Messages.getString("SimpleQueueConfigPage_QueueDescription"));
        this.lblQueueDescripiton.setLayoutData((Object)gd);
        this.txtQueueDescription = toolkit.createText(client, "", 576);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 2;
        gd.horizontalSpan = 3;
        gd.widthHint = 285;
        gd.heightHint = 100;
        this.txtQueueDescription.setLayoutData((Object)gd);
        this.lblQueueType = toolkit.createLabel(client, Messages.getString("SimpleQueueConfigPage_QueueType"));
        gd = new GridData();
        this.cmbQueueType = new Combo(client, 76);
        this.cmbQueueType.setData((Object)"FormWidgetFactory.drawBorder");
        this.queueAdapter.attachQueueType(this.cmbQueueType);
        gd.horizontalSpan = 3;
        gd.widthHint = 300;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 2;
        this.cmbQueueType.setLayoutData((Object)gd);
        this.lblQueueStatus = toolkit.createLabel(client, Messages.getString("SimpleQueueConfigPage_QueueStatus"));
        this.cmbQueueStatus = new Combo(client, 76);
        this.cmbQueueStatus.setData((Object)"FormWidgetFactory.drawBorder");
        this.queueAdapter.attachQueueStatus(this.cmbQueueStatus);
        gd.horizontalSpan = 3;
        this.cmbQueueStatus.setLayoutData((Object)gd);
        this.lblQueueStarted = toolkit.createLabel(client, Messages.getString("SimpleQueueConfigPage_QueueStarted"));
        this.cmbQueueStarted = new Combo(client, 76);
        this.cmbQueueStarted.setData((Object)"FormWidgetFactory.drawBorder");
        this.queueAdapter.attachQueueStarted(this.cmbQueueStarted);
        gd.horizontalSpan = 3;
        this.cmbQueueStarted.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.lblMaxCPUTime = toolkit.createLabel(client, Messages.getString("SimpleQueueConfigPage_MaxCPUTime"));
        Composite timeComp = new Composite(client, 0);
        timeComp.setLayout((Layout)new GridLayout(3, false));
        this.timeCPUHourSpin = new Spinner(timeComp, 2048);
        this.timeCPUHourSpin.setValues(172800, 0, 9999999, 0, 1000, 2000);
        this.lblDivider = toolkit.createLabel(timeComp, "sec");
        this.queueAdapter.attachMaxCPUTimeSpinner(this.timeCPUHourSpin);
        gd.horizontalSpan = 3;
        timeComp.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.lblMaxWallTime = toolkit.createLabel(client, Messages.getString("SimpleQueueConfigPage_MaxWallTime"));
        timeComp = new Composite(client, 0);
        timeComp.setLayout((Layout)new GridLayout(3, false));
        this.timeWallHourSpin = new Spinner(timeComp, 2048);
        this.timeWallHourSpin.setValues(172800, 0, 9999999, 0, 1000, 2000);
        this.lblDivider = toolkit.createLabel(timeComp, "sec");
        this.queueAdapter.attachMaxWallTimeSpinner(this.timeWallHourSpin);
        gd.horizontalSpan = 3;
        timeComp.setLayoutData((Object)gd);
        gd = new GridData();
        gd.verticalSpan = 3;
        gd.horizontalSpan = 1;
        gd.verticalAlignment = 1;
        this.lblVOS = toolkit.createLabel(client, Messages.getString("SimpleQueueConfigPage_AllowedVOs"));
        this.lblVOS.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 3;
        gd.horizontalSpan = 1;
        gd.widthHint = 250;
        gd.heightHint = 100;
        this.tableViewer = new TableViewer(client, 67586);
        this.tblAllowedVOs = this.tableViewer.getTable();
        this.tableViewer.setContentProvider((IContentProvider)new QueueContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new QueueLabelProvider());
        this.queueAdapter.attachAllowedVOs(this.tableViewer);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SimpleQueueConfigPage.this.updateButtons((TableViewer)event.getSource());
            }
        });
        this.tblAllowedVOs.setData((Object)"FormWidgetFactory.drawBorder");
        this.tblAllowedVOs.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalSpan = 1;
        gd.widthHint = 60;
        this.btnAdd = toolkit.createButton(client, Messages.getString("QueueEditor_AddButton"), 524288);
        this.btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SimpleQueueConfigPage.this.handleAddDialog(Messages.getString("QueueEditor_AllowedVOsDialog"), (Button)event.getSource());
                SimpleQueueConfigPage.this.queueAdapter.addAllowedVO(SimpleQueueConfigPage.this.tableViewer, SimpleQueueConfigPage.this.value);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.btnAdd.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalSpan = 1;
        gd.widthHint = 60;
        this.btnEdit = toolkit.createButton(client, Messages.getString("QueueEditor_EditButton"), 8);
        this.btnEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SimpleQueueConfigPage.this.handleAddDialog(Messages.getString("QueueEditor_AllowedVOsDialog"), (Button)event.getSource());
                SimpleQueueConfigPage.this.queueAdapter.editAllowedVO(SimpleQueueConfigPage.this.tableViewer, SimpleQueueConfigPage.this.value);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.btnEdit.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalSpan = 1;
        gd.widthHint = 60;
        gd.verticalAlignment = 1;
        this.btnDel = toolkit.createButton(client, Messages.getString("QueueEditor_RemoveButton"), 8);
        this.btnDel.setEnabled(false);
        this.btnDel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SimpleQueueConfigPage.this.queueAdapter.deleteAllowedVo(SimpleQueueConfigPage.this.tableViewer);
            }
        });
        this.btnDel.setLayoutData((Object)gd);
        this.updateButtons(this.tableViewer);
        toolkit.paintBordersFor(client);
    }

    private boolean isContentRefreshed() {
        return this.contentRefreshed;
    }

    public void notifyChanged(Notification notification) {
        this.setDirty(true);
    }

    protected void updateButtons(TableViewer tblViewer) {
        ISelection selection = tblViewer.getSelection();
        boolean selectionAvailable = !selection.isEmpty();
        this.btnAdd.setEnabled(true);
        this.btnEdit.setEnabled(selectionAvailable);
        this.btnDel.setEnabled(selectionAvailable);
    }

    protected void handleAddDialog(String dialogTitle, Button button) {
        this.value = null;
        AllowedVOsDialog dialog = new AllowedVOsDialog(this.getSite().getShell(), dialogTitle);
        if (button == this.btnEdit) {
            IStructuredSelection structSelection = (IStructuredSelection)this.tableViewer.getSelection();
            String voName = (String)structSelection.getFirstElement();
            dialog.setInput(voName);
        }
        if (dialog.open() != 0) {
            return;
        }
        this.value = dialog.getValue();
    }

    protected void addFormPageHelp(final ScrolledForm form) {
        final String href = this.getHelpResource();
        if (href != null) {
            IToolBarManager manager = form.getToolBarManager();
            Action helpAction = new Action("help"){

                public void run() {
                    BusyIndicator.showWhile((Display)form.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
                        }
                    });
                }
            };
            helpAction.setToolTipText(Messages.getString("QdlEditorPage_HelpToolTip"));
            URL stageInURL = Activator.getDefault().getBundle().getEntry("icons/help.gif");
            this.helpDesc = ImageDescriptor.createFromURL((URL)stageInURL);
            helpAction.setImageDescriptor(this.helpDesc);
            manager.add((IAction)helpAction);
            form.updateToolBar();
        }
    }

    protected String getHelpResource() {
        return "/eu.geclipse.doc.user/html/concepts/siteadministration/editorpages/SimpleParametersPage.html";
    }
}

