/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.parts;

import eu.geclipse.batch.ui.internal.model.BatchDiagram;
import eu.geclipse.batch.ui.internal.model.Box;
import eu.geclipse.batch.ui.internal.model.ComputingElement;
import eu.geclipse.batch.ui.internal.model.Connection;
import eu.geclipse.batch.ui.internal.model.Queue;
import eu.geclipse.batch.ui.internal.model.WorkerNode;
import eu.geclipse.batch.ui.internal.parts.BoxEditPart;
import eu.geclipse.batch.ui.internal.parts.ComputingElementEditPart;
import eu.geclipse.batch.ui.internal.parts.ConnectionEditPart;
import eu.geclipse.batch.ui.internal.parts.DiagramEditPart;
import eu.geclipse.batch.ui.internal.parts.QueueEditPart;
import eu.geclipse.batch.ui.internal.parts.WorkerNodeEditPart;
import java.beans.PropertyChangeListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

public class BatchEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object modelElement) {
        EditPart part = this.getPartForElement(modelElement);
        part.setModel(modelElement);
        return part;
    }

    private EditPart getPartForElement(Object modelElement) {
        PropertyChangeListener part = null;
        if (modelElement instanceof BatchDiagram) {
            part = new DiagramEditPart();
        } else if (modelElement instanceof ComputingElement) {
            part = new ComputingElementEditPart();
        } else if (modelElement instanceof WorkerNode) {
            part = new WorkerNodeEditPart();
        } else if (modelElement instanceof Queue) {
            part = new QueueEditPart();
        } else if (modelElement instanceof Connection) {
            part = new ConnectionEditPart();
        } else if (modelElement instanceof Box) {
            part = new BoxEditPart();
        } else {
            throw new RuntimeException("Can't create part for model element: " + (modelElement != null ? modelElement.getClass().getName() : "null"));
        }
        return part;
    }
}

