/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.parts;

import eu.geclipse.batch.ui.internal.model.BatchResource;
import eu.geclipse.batch.ui.internal.model.Box;
import eu.geclipse.batch.ui.internal.model.ModelElement;
import eu.geclipse.batch.ui.internal.parts.BatchTreeEditPart;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxTreeEditPart
extends BatchTreeEditPart
implements PropertyChangeListener {
    protected Display display;

    public BoxTreeEditPart(BatchResource model) {
        super(model);
    }

    private Box getCastedModel() {
        return (Box)this.getModel();
    }

    public Box getMod() {
        return (Box)this.getModel();
    }

    private EditPart getEditPartForChild(Object child) {
        return (EditPart)this.getViewer().getEditPartRegistry().get(child);
    }

    @Override
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
            this.display = this.getRoot().getViewer().getControl().getDisplay();
        }
    }

    @Override
    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    @Override
    protected void createEditPolicies() {
        if (this.getParent() instanceof RootEditPart) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        }
    }

    protected List<BatchResource> getModelChildren() {
        return this.getCastedModel().getChildren();
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("BatchDiagram.ChildAdded".equals(prop)) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    BoxTreeEditPart.this.addChild(BoxTreeEditPart.this.createChild(evt.getNewValue()), -1);
                }
            });
        } else if ("BatchDiagram.ChildrenAdded".equals(prop)) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    List childrenTmp = (List)evt.getNewValue();
                    for (BatchResource child : childrenTmp) {
                        BoxTreeEditPart.this.addChild(BoxTreeEditPart.this.createChild(child), -1);
                    }
                }
            });
        } else if ("BatchDiagram.ChildRemoved".equals(prop)) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    EditPart tmpPart;
                    Object obj = evt.getNewValue();
                    if (obj != null && (tmpPart = BoxTreeEditPart.this.getEditPartForChild(obj)) != null) {
                        BoxTreeEditPart.this.removeChild(tmpPart);
                    }
                }
            });
        } else {
            this.display.syncExec(new Runnable(){

                public void run() {
                    BoxTreeEditPart.this.refreshVisuals();
                }
            });
        }
    }
}

