/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.wizards;

import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.wizards.BatchDefinitionWizardPage;
import eu.geclipse.batch.ui.wizards.BatchLocationWizardPage;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.reporting.ProblemException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class BatchCreationWizard
extends Wizard
implements INewWizard {
    private BatchLocationWizardPage fileCreationPage;
    private BatchDefinitionWizardPage definitionPage;
    private IFile file;
    private IStructuredSelection selection;

    public BatchCreationWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.fileCreationPage);
        this.addPage((IWizardPage)this.definitionPage);
    }

    public String getWindowTitle() {
        return Messages.getString("BatchCreationWizard.WindowTitle");
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage != this.fileCreationPage) {
            result = super.canFinish();
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        this.selection = sel;
        this.fileCreationPage = new BatchLocationWizardPage(sel);
        this.definitionPage = new BatchDefinitionWizardPage();
    }

    private void openFile() {
        try {
            IDE.openEditor((IWorkbenchPage)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.file, (boolean)true);
        }
        catch (PartInitException partInitException) {
            Activator.logException((Exception)((Object)partInitException));
        }
    }

    public IGridProject getGridProject() {
        Object selected;
        IGridProject result = null;
        if (this.selection != null && (selected = this.selection.getFirstElement()) != null && selected instanceof IGridElement) {
            result = ((IGridElement)selected).getProject();
        }
        return result;
    }

    public boolean performFinish() {
        boolean ret = false;
        if (this.definitionPage.isInputValid()) {
            this.file = this.fileCreationPage.createFile();
            try {
                if (this.definitionPage.finish(this.file)) {
                    this.openFile();
                    ret = true;
                }
            }
            catch (ProblemException problemException) {}
        }
        return ret;
    }
}

