/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.wizards;

import eu.geclipse.batch.BatchConnectionInfo;
import eu.geclipse.batch.Extensions;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.wizards.BatchCreationWizard;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.AbstractVirtualOrganization;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.widgets.StoredCombo;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class BatchDefinitionWizardPage
extends WizardPage {
    private static final String HOSTNAME_STRINGS = "hostname_string";
    private Composite mainComp;
    private Label hostNameLabel;
    private Label accountUserNameLabel;
    private Label batchTypeLabel;
    private Label intervalLabel;
    private StoredCombo hostNameCombo;
    private Text accountUserNameText;
    private Spinner intervalSpinner;
    private Combo batchTypeCombo;

    public BatchDefinitionWizardPage() {
        super("batchDefinitionPage");
        this.setTitle(Messages.getString("BatchDefinitionWizardPage.WindowTitle"));
        this.setDescription(Messages.getString("BatchDefinitionWizardPage.Description"));
    }

    public void createControl(Composite parent) {
        GridData lData = new GridData();
        lData.minimumHeight = 0;
        this.mainComp = new Composite(parent, 0);
        this.mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.mainComp.setLayoutData((Object)gData);
        this.hostNameLabel = new Label(this.mainComp, 0);
        this.hostNameLabel.setText(Messages.getString("BatchDefinitionWizardPage.HostName"));
        this.hostNameLabel.setLayoutData((Object)lData);
        Activator activator = Activator.getDefault();
        IPreferenceStore preferenceStore = activator.getPreferenceStore();
        this.hostNameCombo = new StoredCombo(this.mainComp, 4);
        this.hostNameCombo.setPreferences(preferenceStore, HOSTNAME_STRINGS);
        this.hostNameCombo.setLayoutData((Object)gData);
        this.hostNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BatchDefinitionWizardPage.this.updateUI();
            }
        });
        this.accountUserNameLabel = new Label(this.mainComp, 0);
        this.accountUserNameText = this.createEditorField(this.mainComp, this.accountUserNameLabel, Messages.getString("BatchDefinitionWizardPage.UserName"));
        this.accountUserNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BatchDefinitionWizardPage.this.updateUI();
            }
        });
        this.batchTypeLabel = new Label(this.mainComp, 0);
        this.batchTypeLabel.setText(Messages.getString("BatchDefinitionWizardPage.BatchType"));
        this.batchTypeLabel.setLayoutData((Object)lData);
        this.batchTypeCombo = new Combo(this.mainComp, 2056);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        gData.minimumHeight = 0;
        this.batchTypeCombo.setLayoutData((Object)gData);
        this.initializeServiceCombo(this.batchTypeCombo);
        if (this.batchTypeCombo.getItemCount() == 0) {
            this.setErrorMessage(Messages.getString("BatchDefinitionWizardPage.BatchTypeError"));
        } else {
            this.batchTypeCombo.select(0);
        }
        this.intervalLabel = new Label(this.mainComp, 131072);
        this.intervalLabel.setText(Messages.getString("BatchDefinitionWizardPage.Interval"));
        this.intervalLabel.setLayoutData((Object)lData);
        this.intervalSpinner = new Spinner(this.mainComp, 2048);
        this.intervalSpinner.setValues(10, 5, 60, 0, 1, 10);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.intervalSpinner.setLayoutData((Object)gData);
        this.addComputingElements();
        this.setControl((Control)this.mainComp);
        this.isInputValid();
    }

    protected Text createEditorField(Composite parent, Label label, String text) {
        label.setText(text);
        GridData lData = new GridData();
        lData.minimumHeight = 0;
        label.setLayoutData((Object)lData);
        Text editor = new Text(parent, 2048);
        editor.setTextLimit(40);
        GridData eData = new GridData(768);
        eData.grabExcessHorizontalSpace = true;
        eData.minimumHeight = 0;
        editor.setLayoutData((Object)eData);
        return editor;
    }

    protected void initializeServiceCombo(Combo combo) {
        List serviceNames = Extensions.getRegisteredBatchServiceNames();
        String[] schemeArray = serviceNames.toArray(new String[serviceNames.size()]);
        combo.setItems(schemeArray);
    }

    protected void updateUI() {
        this.setPageComplete(this.isInputValid());
    }

    public boolean isInputValid() {
        boolean ret = true;
        if (this.batchTypeCombo.getItemCount() == 0) {
            this.setErrorMessage(Messages.getString("BatchDefinitionWizardPage.BatchTypeError"));
            ret = false;
        } else if (this.hostNameCombo.getText().trim().length() == 0) {
            this.setErrorMessage(Messages.getString("BatchDefinitionWizardPage.HostNameError"));
            ret = false;
        } else if (this.accountUserNameText.getText().trim().length() == 0) {
            this.setErrorMessage(Messages.getString("BatchDefinitionWizardPage.UserNameError"));
            ret = false;
        } else {
            this.setErrorMessage(null);
        }
        return ret;
    }

    protected boolean finish(IFile file) throws ProblemException {
        BatchConnectionInfo info = null;
        boolean ret = false;
        if (this.batchTypeCombo.getItemCount() > 0) {
            String batchName = this.hostNameCombo.getText().trim();
            String account = this.accountUserNameText.getText().trim();
            String batchType = this.batchTypeCombo.getText();
            int updateInterval = this.intervalSpinner.getSelection();
            if (batchName.length() == 0) {
                this.setErrorMessage(Messages.getString("BatchDefinitionWizardPage.HostNameError"));
            } else if (account.length() == 0) {
                this.setErrorMessage(Messages.getString("BatchDefinitionWizardPage.UserNameError"));
            } else {
                info = new BatchConnectionInfo(file);
                info.setConnectionInfo(batchName, account, batchType, updateInterval);
                info.save();
                ret = true;
            }
        }
        return ret;
    }

    private void addComputingElements() {
        IVirtualOrganization vo;
        IGridElement[] elements = null;
        IGridProject pro = ((BatchCreationWizard)this.getWizard()).getGridProject();
        if (pro != null && (vo = (IVirtualOrganization)pro.getVO().getAdapter(AbstractVirtualOrganization.class)) != null) {
            try {
                IGridInfoService infoService = vo.getInfoService();
                IGridElement[] iGridElementArray = elements = infoService.fetchResources(null, vo, GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.computing"), null);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridComputing comp;
                    String hostname;
                    IGridElement elem = iGridElementArray[n2];
                    if (elem instanceof IGridComputing && (hostname = (comp = (IGridComputing)elem).getHostName()) != null && this.hostNameCombo.indexOf(hostname) == -1) {
                        this.hostNameCombo.add(hostname);
                    }
                    ++n2;
                }
                Object[] items = this.hostNameCombo.getItems();
                if (items != null && items.length > 0) {
                    Arrays.sort(items);
                    this.hostNameCombo.removeAll();
                    this.hostNameCombo.setItems((String[])items);
                }
            }
            catch (ProblemException problemException) {}
        }
    }
}

