/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import eu.geclipse.batch.ISSHConnectionInfo;
import eu.geclipse.batch.internal.Activator;
import eu.geclipse.core.portforward.ForwardType;
import eu.geclipse.core.portforward.IForward;
import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.reporting.ReportingPlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.jsch.core.IJSchService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSHConnection {
    private Session session = null;
    private ISSHConnectionInfo userInfo;

    public void createSession(ISSHConnectionInfo sshConnectionInfo, List<IForward> forwards) throws ProblemException {
        try {
            IJSchService service = Activator.getDefault().getJSchService();
            if (service == null) {
                IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.batch.problem.get_ssh_service_failed", null, null, "eu.geclipse.batch");
                throw new ProblemException(problem);
            }
            this.userInfo = sshConnectionInfo;
            this.session = service.createSession(this.userInfo.getHostname(), this.userInfo.getPort(), this.userInfo.getUsername());
            this.session.setUserInfo((UserInfo)this.userInfo);
            if (forwards != null) {
                for (IForward forward : forwards) {
                    if (ForwardType.LOCAL == forward.getType()) {
                        this.session.setPortForwardingL(forward.getBindPort(), forward.getHostname(), forward.getPort());
                        continue;
                    }
                    this.session.setPortForwardingR(forward.getBindPort(), forward.getHostname(), forward.getPort());
                }
            }
            this.session.connect();
        }
        catch (JSchException exception) {
            if (!sshConnectionInfo.getCanceledPWValue()) {
                IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.batch.problem.login_failed", null, (Throwable)exception, "eu.geclipse.batch");
                ISolution solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.batch.solution.check_username_password", null);
                problem.addSolution(solution);
                solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.batch.solution.check_ssh_server_config", null);
                problem.addSolution(solution);
                throw new ProblemException(problem);
            }
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
    }

    public void endSession() {
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public boolean isSessionActive() {
        boolean status = false;
        if (this.session != null) {
            status = this.session.isConnected();
        }
        return status;
    }

    public String execCommand(String command) throws ProblemException {
        return this.execCommand(command, null);
    }

    public String execCommand(String command, InputStream stdin) throws ProblemException {
        Channel channel = null;
        InputStream stdout = null;
        InputStream stderr = null;
        String result = "";
        String errResult = "";
        int exitStatus = -1;
        BufferedReader stdoutReader = null;
        BufferedReader stderrReader = null;
        if (!this.isSessionActive()) {
            IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.core.problem.net.connectionFailed", null, null, "eu.geclipse.batch");
            ISolution solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.core.solution.net.checkInternetConnection", null);
            problem.addSolution(solution);
            throw new ProblemException(problem);
        }
        try {
            try {
                String line;
                channel = this.session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                channel.setInputStream(stdin);
                stdout = channel.getInputStream();
                stderr = channel.getExtInputStream();
                channel.connect();
                stdoutReader = new BufferedReader(new InputStreamReader(stdout));
                stderrReader = new BufferedReader(new InputStreamReader(stderr));
                while (!channel.isClosed()) {
                    line = stdoutReader.readLine();
                    while (line != null) {
                        result = String.valueOf(result) + line + '\n';
                        line = stdoutReader.readLine();
                    }
                    line = stderrReader.readLine();
                    while (line != null) {
                        errResult = String.valueOf(errResult) + line + '\n';
                        line = stderrReader.readLine();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
                line = stdoutReader.readLine();
                while (line != null) {
                    result = String.valueOf(result) + line + '\n';
                    line = stdoutReader.readLine();
                }
                line = stderrReader.readLine();
                while (line != null) {
                    errResult = String.valueOf(errResult) + line + '\n';
                    line = stderrReader.readLine();
                }
                exitStatus = channel.getExitStatus();
                channel.disconnect();
            }
            catch (JSchException jschExc) {
                IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.core.problem.net.connectionFailed", null, (Throwable)jschExc, "eu.geclipse.batch");
                ISolution solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.core.solution.net.checkInternetConnection", null);
                problem.addSolution(solution);
                solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.batch.solution.check_username_password", null);
                problem.addSolution(solution);
                solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.core.solution.net.checkFirewall", null);
                problem.addSolution(solution);
                throw new ProblemException(problem);
            }
            catch (IOException ioExc) {
                IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.batch.problem.io_error", null, (Throwable)ioExc, "eu.geclipse.batch");
                ISolution solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.core.solution.net.checkInternetConnection", null);
                problem.addSolution(solution);
                throw new ProblemException(problem);
            }
        }
        catch (Throwable throwable) {
            if (stdoutReader != null) {
                try {
                    stdoutReader.close();
                }
                catch (IOException iOException) {}
            }
            if (stderrReader != null) {
                try {
                    stderrReader.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (stdoutReader != null) {
            try {
                stdoutReader.close();
            }
            catch (IOException iOException) {}
        }
        if (stderrReader != null) {
            try {
                stderrReader.close();
            }
            catch (IOException iOException) {}
        }
        if ((exitStatus != 0 || errResult.length() > 0) && result.length() == 0) {
            if (errResult.length() > 0) {
                IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.batch.problem.command_failed", errResult, null, "eu.geclipse.batch");
                throw new ProblemException(problem);
            }
            IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.batch.problem.command_failed", null, null, "eu.geclipse.batch");
            throw new ProblemException(problem);
        }
        if (result.length() == 0) {
            result = null;
        }
        return result;
    }
}

