/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.pbs;

import eu.geclipse.batch.AbstractBatchService;
import eu.geclipse.batch.IBatchJobInfo;
import eu.geclipse.batch.IBatchJobManager;
import eu.geclipse.batch.IBatchServiceDescription;
import eu.geclipse.batch.IQueueInfo;
import eu.geclipse.batch.ISSHConnectionInfo;
import eu.geclipse.batch.IWorkerNodeInfo;
import eu.geclipse.batch.internal.QueueInfo;
import eu.geclipse.batch.internal.WorkerNodeInfo;
import eu.geclipse.batch.model.qdl.DocumentRoot;
import eu.geclipse.batch.model.qdl.QueueStatusEnumeration;
import eu.geclipse.batch.model.qdl.QueueType;
import eu.geclipse.batch.model.qdl.QueueTypeEnumeration;
import eu.geclipse.core.reporting.ProblemException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PBSBatchService
extends AbstractBatchService {
    private String pbsCmdPath = null;
    private String qmgrCmdPath = null;
    private final List<IBatchJobInfo> tmpJobs = new ArrayList<IBatchJobInfo>();

    public PBSBatchService(IBatchServiceDescription description, String name) {
        super(description, name);
    }

    private IBatchJobInfo parseJobLine(String jobLine, IBatchJobManager manager) {
        IBatchJobInfo jobInfo = null;
        IBatchJobInfo.JobState status = null;
        String[] lineSplit = jobLine.split(" +");
        if (6 == lineSplit.length) {
            String jobId = lineSplit[0];
            String jobName = lineSplit[1];
            String userAccount = lineSplit[2];
            String timeUse = lineSplit[3];
            try {
                status = IBatchJobInfo.JobState.valueOf(lineSplit[4]);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            String queueName = lineSplit[5];
            if (status != null) {
                jobInfo = manager.addMerge(jobId, jobName, userAccount, timeUse, status, queueName, this);
            }
        }
        return jobInfo;
    }

    private QueueInfo parseQueueLine(String queueLine) {
        QueueInfo queueInfo = null;
        IQueueInfo.QueueState state = null;
        IQueueInfo.QueueRunState runState = null;
        int memory = -1;
        int run = -1;
        int que = -1;
        String[] lineSplit = queueLine.split(" +");
        if (10 == lineSplit.length) {
            String queueName = lineSplit[0];
            try {
                memory = Integer.parseInt(lineSplit[1]);
            }
            catch (NumberFormatException numberFormatException) {}
            String timeCPU = lineSplit[2];
            String timeWall = lineSplit[3];
            String node = lineSplit[4];
            try {
                run = Integer.parseInt(lineSplit[5]);
                que = Integer.parseInt(lineSplit[6]);
            }
            catch (NumberFormatException numberFormatException) {}
            String lm = lineSplit[7];
            try {
                state = IQueueInfo.QueueState.valueOf(lineSplit[8]);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            try {
                runState = IQueueInfo.QueueRunState.valueOf(lineSplit[9]);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (state != null) {
                queueInfo = new QueueInfo(queueName, memory, timeCPU, timeWall, node, run, que, lm, state, runState);
            }
        }
        return queueInfo;
    }

    private String getRightHandSide(String line, String identifier) {
        String str = null;
        int idx = line.indexOf(identifier);
        if (-1 != idx) {
            str = line.substring(idx + identifier.length());
        }
        return str;
    }

    private String findJobId(String jobIdLine) {
        int beginIndex = jobIdLine.indexOf(47) + 1;
        int endIndex = jobIdLine.indexOf(46) + 1;
        String ret = -1 == jobIdLine.indexOf(46, endIndex) ? jobIdLine.substring(beginIndex) : jobIdLine.substring(beginIndex, jobIdLine.indexOf(46, endIndex));
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private List<IWorkerNodeInfo> parseNodes(String nodeLines) {
        wnFQN = null;
        properties = null;
        type = null;
        status = null;
        job = null;
        state = null;
        np = -1;
        beginIndex = 0;
        line = null;
        wns = new ArrayList<IWorkerNodeInfo>();
        jobs = null;
        ** GOTO lbl84
        {
            endIndex = nodeLines.indexOf(10, ++beginIndex);
            do {
                if (beginIndex == endIndex && beginIndex < nodeLines.length()) continue block4;
                if (-1 == endIndex) break block4;
                wnFQN = nodeLines.substring(beginIndex, endIndex);
                beginIndex = endIndex + 1;
                if (-1 != (endIndex = nodeLines.indexOf(10, beginIndex))) {
                    line = nodeLines.substring(beginIndex, endIndex);
                    tmpIdx = (line = this.getRightHandSide(line, "state = ")).indexOf(44);
                    if (-1 != tmpIdx) {
                        line = line.substring(0, tmpIdx);
                    }
                    try {
                        state = IWorkerNodeInfo.WorkerNodeState.valueOfEnhanced(line);
                    }
                    catch (IllegalArgumentException v0) {}
                }
                if (-1 != (endIndex = nodeLines.indexOf(10, beginIndex = endIndex + 1))) {
                    line = nodeLines.substring(beginIndex, endIndex);
                    if ((line = this.getRightHandSide(line, "np = ")) != null) {
                        try {
                            np = Integer.parseInt(line);
                        }
                        catch (NumberFormatException v1) {
                            np = -1;
                        }
                    } else {
                        np = -1;
                    }
                }
                if (-1 != (endIndex = nodeLines.indexOf(10, beginIndex = endIndex + 1))) {
                    line = nodeLines.substring(beginIndex, endIndex);
                    properties = this.getRightHandSide(line, "properties = ");
                }
                if (properties == null && line != null) {
                    type = this.getRightHandSide(line, "ntype = ");
                } else {
                    beginIndex = endIndex + 1;
                    if (-1 != (endIndex = nodeLines.indexOf(10, beginIndex))) {
                        line = nodeLines.substring(beginIndex, endIndex);
                        type = this.getRightHandSide(line, "ntype = ");
                    }
                }
                do {
                    if (-1 == (endIndex = nodeLines.indexOf(10, beginIndex = endIndex + 1))) continue;
                    line = nodeLines.substring(beginIndex, endIndex);
                    job = this.getRightHandSide(line, "jobs = ");
                    if (job != null) {
                        if (jobs == null) {
                            jobs = new ArrayList<String>();
                        }
                        beginJobIdx = 0;
                        endJobIdx = job.indexOf(44);
                        while (-1 != endJobIdx) {
                            tmpJob = job.substring(beginJobIdx, endJobIdx);
                            tmpJob = tmpJob.trim();
                            jobs.add(this.findJobId(tmpJob));
                            beginJobIdx = endJobIdx + 1;
                            endJobIdx = job.indexOf(44, beginJobIdx);
                        }
                        tmpJob = job.substring(beginJobIdx);
                        tmpJob = tmpJob.trim();
                        jobs.add(this.findJobId(tmpJob));
                        continue;
                    }
                    status = this.getRightHandSide(line, "status = ");
                } while (job != null);
                if (wnFQN != null && state != null && -1 != np && type != null) {
                    wnInfo = new WorkerNodeInfo(wnFQN, state, np, properties, type, status, jobs);
                    wns.add(wnInfo);
                }
                wnFQN = null;
                state = null;
                properties = null;
                type = null;
                status = null;
                if (jobs != null) {
                    jobs = null;
                }
                beginIndex = endIndex + 1;
lbl84:
                // 2 sources

            } while (-1 != (endIndex = nodeLines.indexOf(10, beginIndex)));
        }
        if (wns.isEmpty()) {
            wns = null;
        }
        return wns;
    }

    @Override
    public synchronized boolean connectToServer(ISSHConnectionInfo sshConnectionInfo) throws ProblemException {
        boolean ret;
        block12: {
            ret = super.connectToServer(sshConnectionInfo);
            if (ret) {
                int idx;
                String cmd;
                block11: {
                    try {
                        this.qmgrCmdPath = this.connection.execCommand("qmgr -c help");
                        this.qmgrCmdPath = "";
                    }
                    catch (ProblemException problemException) {
                        try {
                            cmd = " /bin/sh -l -c 'which -- qmgr\\' ";
                            this.qmgrCmdPath = this.connection.execCommand(cmd);
                            if (this.qmgrCmdPath != null && -1 != (idx = this.qmgrCmdPath.lastIndexOf("qmgr"))) {
                                this.qmgrCmdPath = this.qmgrCmdPath.substring(0, idx);
                            }
                        }
                        catch (ProblemException problemException2) {
                            cmd = "/bin/sh -l -c \"find / -xdev -maxdepth 10 -executable -type f -name qmgr 2> /dev/null\"";
                            this.qmgrCmdPath = this.connection.execCommand(cmd);
                            if (this.qmgrCmdPath == null || -1 == (idx = this.qmgrCmdPath.lastIndexOf("qmgr"))) break block11;
                            this.qmgrCmdPath = this.qmgrCmdPath.substring(0, idx);
                        }
                    }
                }
                try {
                    this.pbsCmdPath = this.connection.execCommand("pbsnodes");
                    this.pbsCmdPath = "";
                }
                catch (ProblemException problemException) {
                    try {
                        cmd = "/bin/sh -l -c 'which pbsnodes\\'";
                        this.pbsCmdPath = this.connection.execCommand(cmd);
                        if (this.pbsCmdPath != null && -1 != (idx = this.pbsCmdPath.lastIndexOf("pbsnodes"))) {
                            this.pbsCmdPath = this.pbsCmdPath.substring(0, idx);
                        }
                    }
                    catch (ProblemException problemException3) {
                        cmd = "/bin/sh -l -c \"find / -xdev -maxdepth 10 -executable -type f -name pbsnodes 2> /dev/null\"";
                        this.pbsCmdPath = this.connection.execCommand(cmd);
                        if (this.pbsCmdPath == null || -1 == (idx = this.pbsCmdPath.lastIndexOf("pbsnodes"))) break block12;
                        this.pbsCmdPath = this.pbsCmdPath.substring(0, idx);
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public synchronized void getJobs(IBatchJobManager manager) throws ProblemException {
        String outPut = this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qstat");
        this.tmpJobs.clear();
        if (outPut != null) {
            int endIndex;
            int beginIndex = 0;
            int skip = 0;
            while (-1 != (endIndex = outPut.indexOf(10, beginIndex))) {
                IBatchJobInfo jobInfo;
                String line = outPut.substring(beginIndex, endIndex);
                if (2 < ++skip && (jobInfo = this.parseJobLine(line, manager)) != null) {
                    this.tmpJobs.add(jobInfo);
                }
                beginIndex = endIndex + 1;
            }
        }
        manager.removeOld(this.tmpJobs);
    }

    @Override
    public synchronized void delJob(String jobId) throws ProblemException {
        if (jobId != null) {
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qdel " + jobId);
        }
    }

    @Override
    public synchronized void moveJob(String jobId, String destQueue, String destServer) throws ProblemException {
        String cmd = "qmove ";
        if (jobId != null) {
            if (destServer != null && destQueue != null) {
                cmd = String.valueOf(cmd) + destQueue + "@" + destServer;
            } else if (destServer == null) {
                cmd = String.valueOf(cmd) + destQueue;
            } else if (destQueue == null) {
                cmd = String.valueOf(cmd) + destServer;
            } else assert (false);
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + cmd + " " + jobId);
        }
    }

    @Override
    public synchronized void moveJobs(String[] jobIds, String destQueue, String destServer) throws ProblemException {
        String strJobs = null;
        String cmd = "qmove ";
        if (jobIds != null) {
            if (destServer != null && destQueue != null) {
                cmd = String.valueOf(cmd) + destQueue + "@" + destServer;
            } else if (destServer == null) {
                cmd = String.valueOf(cmd) + destQueue;
            } else if (destQueue == null) {
                cmd = String.valueOf(cmd) + destServer;
            } else assert (false);
            String[] stringArray = jobIds;
            int n = jobIds.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                strJobs = String.valueOf(str) + " ";
                ++n2;
            }
            if (strJobs != null) {
                strJobs = strJobs.trim();
                this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + cmd + " " + strJobs);
            }
        }
    }

    @Override
    public synchronized void holdJob(String jobId) throws ProblemException {
        if (jobId != null) {
            String cmd = "qhold " + jobId;
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + cmd);
        }
    }

    @Override
    public synchronized void holdJobs(String[] jobIds) throws ProblemException {
        String strJobs = null;
        String cmd = "qhold ";
        String[] stringArray = jobIds;
        int n = jobIds.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            strJobs = String.valueOf(str) + " ";
            ++n2;
        }
        if (strJobs != null) {
            strJobs = strJobs.trim();
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + cmd + " " + strJobs);
        }
    }

    @Override
    public synchronized void releaseJob(String jobId) throws ProblemException {
        if (jobId != null) {
            String cmd = "qrls " + jobId;
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + cmd);
        }
    }

    @Override
    public synchronized void releaseJobs(String[] jobIds) throws ProblemException {
        String strJobs = null;
        String cmd = "qrls ";
        String[] stringArray = jobIds;
        int n = jobIds.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            strJobs = String.valueOf(str) + " ";
            ++n2;
        }
        if (strJobs != null) {
            strJobs = strJobs.trim();
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + cmd + " " + strJobs);
        }
    }

    @Override
    public synchronized void reRunJob(String jobId) throws ProblemException {
        if (jobId != null) {
            String cmd = "qrerun " + jobId;
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + cmd);
        }
    }

    @Override
    public synchronized void reRunJobs(String[] jobIds) throws ProblemException {
        String strJobs = null;
        String cmd = "qrerun ";
        String[] stringArray = jobIds;
        int n = jobIds.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            strJobs = String.valueOf(str) + " ";
            ++n2;
        }
        if (strJobs != null) {
            strJobs = strJobs.trim();
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + cmd + " " + strJobs);
        }
    }

    @Override
    public synchronized List<IWorkerNodeInfo> getWorkerNodes() throws ProblemException {
        List<IWorkerNodeInfo> wns = null;
        String outPut = this.connection.execCommand(String.valueOf(this.pbsCmdPath) + "pbsnodes");
        if (outPut != null) {
            wns = this.parseNodes(outPut);
        }
        return wns;
    }

    @Override
    public synchronized void disableWN(String nodeId) throws ProblemException {
        if (nodeId != null) {
            String cmd = "qmgr -c \"set node ";
            cmd = String.valueOf(cmd) + nodeId;
            cmd = String.valueOf(cmd) + " state = offline\"";
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + cmd);
        }
    }

    @Override
    public synchronized void enableWN(String nodeId) throws ProblemException {
        if (nodeId != null) {
            String cmd = "qmgr -c \"set node ";
            cmd = String.valueOf(cmd) + nodeId;
            cmd = String.valueOf(cmd) + " state = free\"";
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + cmd);
        }
    }

    @Override
    public synchronized List<IQueueInfo> getQueues() throws ProblemException {
        ArrayList<QueueInfo> queues = null;
        String outPut = this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qstat -q");
        if (outPut != null) {
            int endIndex;
            queues = new ArrayList<QueueInfo>();
            int beginIndex = 0;
            int skip = 0;
            while (-1 != (endIndex = outPut.indexOf(10, beginIndex))) {
                QueueInfo queueInfo;
                String line = outPut.substring(beginIndex, endIndex);
                if (5 < ++skip && (queueInfo = this.parseQueueLine(line)) != null) {
                    queues.add(queueInfo);
                }
                beginIndex = endIndex + 1;
            }
            if (queues.isEmpty()) {
                queues = null;
            }
        }
        return queues;
    }

    @Override
    public synchronized void disableQueue(String queueId) throws ProblemException {
        if (queueId != null) {
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qdisable " + queueId);
        }
    }

    @Override
    public synchronized void disableQueues(String[] queueIds) throws ProblemException {
        if (queueIds != null && queueIds.length > 0) {
            String queues = "";
            String[] stringArray = queueIds;
            int n = queueIds.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                queues = String.valueOf(queues) + str + " ";
                ++n2;
            }
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qdisable " + queues);
        }
    }

    @Override
    public synchronized void enableQueue(String queueId) throws ProblemException {
        if (queueId != null) {
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qenable " + queueId);
        }
    }

    @Override
    public synchronized void enableQueues(String[] queueIds) throws ProblemException {
        if (queueIds != null && queueIds.length > 0) {
            String queues = "";
            String[] stringArray = queueIds;
            int n = queueIds.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                queues = String.valueOf(queues) + str + " ";
                ++n2;
            }
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qenable " + queues);
        }
    }

    @Override
    public synchronized void startQueue(String queueId) throws ProblemException {
        if (queueId != null) {
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qstart " + queueId);
        }
    }

    @Override
    public synchronized void startQueues(String[] queueIds) throws ProblemException {
        if (queueIds != null && queueIds.length > 0) {
            String queues = "";
            String[] stringArray = queueIds;
            int n = queueIds.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                queues = String.valueOf(queues) + str + " ";
                ++n2;
            }
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qstart " + queues);
        }
    }

    @Override
    public synchronized void stopQueue(String queueId) throws ProblemException {
        if (queueId != null) {
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qstop " + queueId);
        }
    }

    @Override
    public synchronized void stopQueues(String[] queueIds) throws ProblemException {
        if (queueIds != null && queueIds.length > 0) {
            String queues = "";
            String[] stringArray = queueIds;
            int n = queueIds.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                queues = String.valueOf(queues) + str + " ";
                ++n2;
            }
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qstop " + queues);
        }
    }

    @Override
    public synchronized void createQueue(String queueName, IQueueInfo.QueueType type, boolean enabled, double timeCPU, double timeWall, List<String> vos) throws ProblemException {
        if (queueName != null && type != null && -1.0 != timeCPU && -1.0 != timeWall) {
            String adaptedTimeCPU = null;
            double newTimeWallHours = timeWall / 3600.0;
            double newTimeCPUHours = timeCPU / 3600.0;
            String adaptedTimeWall = String.format("%02d:%02d:00", PBSBatchService.getHoursFromDouble(newTimeWallHours), PBSBatchService.getMinutesFromDouble(newTimeWallHours));
            adaptedTimeCPU = String.format("%02d:%02d:00", PBSBatchService.getHoursFromDouble(newTimeCPUHours), PBSBatchService.getMinutesFromDouble(newTimeCPUHours));
            String cmd = String.valueOf(this.qmgrCmdPath) + "qmgr -c \"create queue ";
            String setAttr = " ; " + this.qmgrCmdPath + "qmgr -c \"set queue " + queueName;
            cmd = String.valueOf(cmd) + queueName;
            cmd = String.valueOf(cmd) + " queue_type=" + type.name() + "\"";
            if (!enabled) {
                cmd = String.valueOf(cmd) + setAttr + " enabled=false\"";
            }
            cmd = String.valueOf(cmd) + setAttr + " resources_max.walltime=" + adaptedTimeWall + "\"";
            cmd = String.valueOf(cmd) + setAttr + " resources_max.cput=" + adaptedTimeCPU + "\"";
            if (vos != null) {
                cmd = String.valueOf(cmd) + setAttr + " acl_group_enable=true\"";
                for (String str : vos) {
                    cmd = String.valueOf(cmd) + setAttr + " acl_groups= +" + str + "\"";
                }
            }
            this.connection.execCommand(cmd);
        }
    }

    @Override
    public synchronized void createQueue(String queueName, int priority, IQueueInfo.QueueType type, boolean enabled, boolean started, int maxRunningJobs, double timeCPU, double timeWall, int maxJobsInQueue, int assignedResources, List<String> vos) throws ProblemException {
        if (queueName != null && type != null && -1.0 != timeCPU && -1.0 != timeWall) {
            String adaptedTimeCPU = null;
            String adaptedTimeWall = String.format("%02d:%02d:00", PBSBatchService.getHoursFromDouble(timeWall), PBSBatchService.getMinutesFromDouble(timeWall));
            adaptedTimeCPU = String.format("%02d:%02d:00", PBSBatchService.getHoursFromDouble(timeCPU), PBSBatchService.getMinutesFromDouble(timeCPU));
            String cmd = String.valueOf(this.qmgrCmdPath) + "qmgr -c \"create queue ";
            String setAttr = " ; " + this.qmgrCmdPath + "qmgr -c \"set queue " + queueName;
            cmd = String.valueOf(cmd) + queueName;
            cmd = String.valueOf(cmd) + " queue_type=" + type.name() + "\"";
            cmd = !enabled ? String.valueOf(cmd) + setAttr + " enabled = False\"" : String.valueOf(cmd) + setAttr + " enabled = True\"";
            cmd = !started ? String.valueOf(cmd) + setAttr + " started = False\"" : String.valueOf(cmd) + setAttr + " started = True\"";
            if (-1 != priority) {
                cmd = String.valueOf(cmd) + setAttr + " priority=" + priority + "\"";
            }
            cmd = String.valueOf(cmd) + setAttr + " resources_max.walltime=" + adaptedTimeWall + "\"";
            cmd = String.valueOf(cmd) + setAttr + " resources_max.cput=" + adaptedTimeCPU + "\"";
            if (-1 != maxRunningJobs) {
                cmd = String.valueOf(cmd) + setAttr + " max_running=" + maxRunningJobs + "\"";
            }
            if (-1 != maxJobsInQueue) {
                cmd = String.valueOf(cmd) + setAttr + " max_queuable=" + maxJobsInQueue + "\"";
            }
            if (vos != null) {
                cmd = String.valueOf(cmd) + setAttr + " acl_group_enable=true\"";
                for (String str : vos) {
                    cmd = String.valueOf(cmd) + setAttr + " acl_groups= +" + str + "\"";
                }
            }
            this.connection.execCommand(cmd);
        }
    }

    @Override
    public synchronized void setMaxWallTime(String queueName, String timeWall) throws ProblemException {
        if (queueName != null && timeWall != null) {
            String cmd = "qmgr -c \"set queue " + queueName;
            cmd = String.valueOf(cmd) + " resources_max.walltime=" + timeWall;
            cmd = String.valueOf(cmd) + "\"";
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + cmd);
        }
    }

    @Override
    public synchronized void delQueue(String queueId) throws ProblemException {
        if (queueId != null) {
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "qmgr -c \"delete queue " + queueId + "\"");
        }
    }

    @Override
    public void createQueue(DocumentRoot documentRoot) throws ProblemException {
        String queueName = null;
        boolean queueStatus = false;
        boolean queueStarted = false;
        int priority = -1;
        int maxRunningJobs = -1;
        int maxJobsInQueue = -1;
        int assignedResources = -1;
        EList vos = null;
        QueueType queue = documentRoot.getQueue();
        IQueueInfo.QueueType type = queue.getQueueType().equals((Object)QueueTypeEnumeration.EXECUTION) ? IQueueInfo.QueueType.execution : IQueueInfo.QueueType.route;
        queueName = queue.getQueueName();
        if (queue.getQueueStatus().equals((Object)QueueStatusEnumeration.ENABLED)) {
            queueStatus = true;
        }
        if (queue.isQueueStarted()) {
            queueStarted = true;
        }
        double timeCPU = queue.getCPUTimeLimit().getUpperBoundedRange().getValue();
        if (queue.getAllowedVirtualOrganizations() != null) {
            vos = queue.getAllowedVirtualOrganizations().getVOName();
        }
        double timeWall = queue.getWallTimeLimit().getUpperBoundedRange().getValue();
        if (queue.getPriority() != null) {
            priority = queue.getPriority().getUpperBoundedRange() != null ? queue.getPriority().getUpperBoundedRange().getValue() : queue.getPriority().getLowerBoundedRange().getValue();
        }
        if (queue.getRunningJobs() != null) {
            maxRunningJobs = queue.getRunningJobs().getUpperBoundedRange() != null ? queue.getRunningJobs().getUpperBoundedRange().getValue() : queue.getRunningJobs().getLowerBoundedRange().getValue();
        }
        if (queue.getJobsInQueue() != null) {
            maxJobsInQueue = queue.getJobsInQueue().getUpperBoundedRange() != null ? queue.getJobsInQueue().getUpperBoundedRange().getValue() : queue.getJobsInQueue().getLowerBoundedRange().getValue();
        }
        if (queue.getAssignedResources() != null && queue.getAssignedResources().getExact() != null) {
            maxJobsInQueue = queue.getJobsInQueue().getUpperBoundedRange().getValue();
        }
        this.createQueue(queueName, priority, type, queueStatus, queueStarted, maxRunningJobs, timeCPU, timeWall, maxJobsInQueue, assignedResources, (List<String>)vos);
    }

    static int getHoursFromDouble(double value) {
        BigDecimal b = new BigDecimal(value / 3600.0);
        double c = b.longValue();
        return (int)c;
    }

    static int getMinutesFromDouble(double value) {
        int result = (int)(value % 3600.0 / 60.0);
        return result;
    }
}

