/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.filesystem.internal.Activator;
import eu.geclipse.core.filesystem.internal.filesystem.ConnectionElement;
import eu.geclipse.core.filesystem.internal.filesystem.ConnectionRoot;
import eu.geclipse.core.model.ICreatorSourceMatcher;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.impl.AbstractGridElementCreator;
import eu.geclipse.core.reporting.ProblemException;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class FileSystemCreator
extends AbstractGridElementCreator
implements ICreatorSourceMatcher {
    public IGridElement create(IGridContainer parent) throws ProblemException {
        ConnectionElement result = null;
        IResource resource = (IResource)this.getSource();
        result = this.isFileSystemLink(resource) && !this.isJobFile(resource) ? this.createConnectionRoot(resource) : this.createConnectionElement(resource);
        return result;
    }

    private ConnectionElement createConnectionElement(IResource resource) {
        ConnectionElement element = new ConnectionElement(resource);
        try {
            IFileInfo info = element.getConnectionFileInfo();
            if (info instanceof FileInfo) {
                FileInfo fileInfo = (FileInfo)info;
                ((FileInfo)info).setExists(true);
                if (resource instanceof IFile) {
                    fileInfo.setDirectory(false);
                }
            }
        }
        catch (CoreException cExc) {
            Activator.logException(cExc);
        }
        return element;
    }

    private ConnectionElement createConnectionRoot(IResource resource) {
        ConnectionRoot connection = null;
        if (resource instanceof IFolder) {
            connection = new ConnectionRoot((IFolder)resource);
        } else if (resource instanceof IFile) {
            connection = new ConnectionRoot((IFile)resource);
        }
        if (connection != null) {
            try {
                IFileInfo info = connection.getConnectionFileInfo();
                if (info instanceof FileInfo) {
                    FileInfo fileInfo = (FileInfo)info;
                    fileInfo.setName(resource.getName());
                    fileInfo.setExists(true);
                    fileInfo.setDirectory(resource instanceof IFolder);
                }
            }
            catch (CoreException cExc) {
                Activator.logException(cExc);
            }
        }
        return connection;
    }

    public boolean canCreate(Object source) {
        boolean result = false;
        if (source instanceof IResource) {
            result = this.isFileSystemElement((IResource)source);
        }
        return result;
    }

    private boolean isFileSystemElement(IResource resource) {
        boolean result = this.isFileSystemLink(resource);
        if (!result && resource != null) {
            result = this.isFileSystemElement((IResource)resource.getParent());
        }
        return result;
    }

    private boolean isFileSystemLink(IResource resource) {
        URI uri;
        boolean result = false;
        if (resource != null && (resource instanceof IFolder || resource instanceof IFile) && resource.isLinked() && (uri = resource.getRawLocationURI()) != null) {
            String scheme = uri.getScheme();
            if (GEclipseURI.getScheme().equals(scheme)) {
                result = true;
            }
        }
        return result;
    }

    private boolean isJobFile(IResource resource) {
        boolean jobFile = false;
        IContainer parent = resource.getParent();
        while (parent != null && !(parent instanceof IProject) && !jobFile) {
            IPath location = parent.getLocation();
            if (location != null) {
                jobFile = "job".equals(location.getFileExtension());
            }
            parent = parent.getParent();
        }
        return jobFile;
    }
}

