/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem;

import eu.geclipse.core.filesystem.Messages;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;

public class GEclipseURI {
    private static final String SCHEME = "gecl";
    private static final String QUERY_TOKEN_SEPARATOR = "&";
    private static final String QUERY_TOKEN_ASSIGN = "=";
    private static final String QUERY_SLAVE_SCHEME_TOKEN = "geclslave";
    private static final String QUERY_UID_TOKEN = "gecluid";
    private static final String QUERY_VO_TOKEN = "vo";
    private URI masterURI;

    public GEclipseURI(URI uri) {
        URI slaveURI = GEclipseURI.getSlaveURI(uri);
        try {
            IFileSystem fileSystem = EFS.getFileSystem((String)slaveURI.getScheme());
            IFileStore fileStore = fileSystem.getStore(slaveURI);
            slaveURI = fileStore.toURI();
        }
        catch (CoreException coreException) {}
        this.masterURI = GEclipseURI.getMasterURI(slaveURI);
    }

    public static String getScheme() {
        return SCHEME;
    }

    public String getSlaveScheme() {
        return this.toSlaveURI().getScheme();
    }

    public URI toMasterURI() {
        return this.masterURI;
    }

    public URI toSlaveURI() {
        return GEclipseURI.getSlaveURI(this.masterURI);
    }

    public String toString() {
        return this.toMasterURI().toString();
    }

    private static URI getMasterURI(URI uri) {
        URI result = uri;
        if (!GEclipseURI.isMasterURI(uri)) {
            String scheme = SCHEME;
            String userInfo = uri.getUserInfo();
            String host = uri.getHost();
            int port = uri.getPort();
            String path = uri.getPath();
            String query = uri.getQuery();
            String fragment = uri.getFragment();
            query = !GEclipseURI.isEmptyString(query) ? String.valueOf(query) + QUERY_TOKEN_SEPARATOR : "";
            query = String.valueOf(query) + "geclslave=" + uri.getScheme();
            String uid = "";
            if (host != null && host.length() > 0) {
                uid = String.valueOf(uid) + host;
            }
            if (port != -1) {
                uid = String.valueOf(uid) + String.valueOf(port);
            }
            if (uid.length() > 0) {
                query = String.valueOf(query) + "&gecluid=" + uid;
            }
            try {
                result = new URI(scheme, userInfo, host, port, path, query, fragment);
            }
            catch (URISyntaxException uriExc) {
                throw new IllegalArgumentException(Messages.getString("GEclipseURI.master_creation_failed"), uriExc);
            }
        }
        return result;
    }

    private static URI getSlaveURI(URI uri) {
        URI result = uri;
        if (uri != null && GEclipseURI.isMasterURI(uri)) {
            String scheme = null;
            String userInfo = uri.getUserInfo();
            String host = uri.getHost();
            int port = uri.getPort();
            String path = uri.getPath();
            String query = uri.getQuery();
            String fragment = uri.getFragment();
            String[] tokens = query.split(QUERY_TOKEN_SEPARATOR);
            query = "";
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                String[] tokenParts = token.split(QUERY_TOKEN_ASSIGN);
                boolean append = true;
                if (tokenParts.length == 2) {
                    if (tokenParts[0].equals(QUERY_SLAVE_SCHEME_TOKEN)) {
                        scheme = tokenParts[1];
                        append = false;
                    } else if (tokenParts[0].equals(QUERY_UID_TOKEN)) {
                        append = false;
                    } else if (tokenParts[0].equals(QUERY_VO_TOKEN)) {
                        append = false;
                    }
                }
                if (append) {
                    if (query.length() > 0) {
                        query = String.valueOf(query) + QUERY_TOKEN_SEPARATOR;
                    }
                    query = String.valueOf(query) + token;
                }
                ++n2;
            }
            if (GEclipseURI.isEmptyString(query)) {
                query = null;
            }
            try {
                result = new URI(scheme, userInfo, host, port, path, query, fragment);
            }
            catch (URISyntaxException uriExc) {
                throw new IllegalArgumentException(Messages.getString("GEclipseURI.slave_creation_failed"), uriExc);
            }
        }
        return result;
    }

    private static boolean isEmptyString(String s) {
        return s == null || s.length() == 0;
    }

    private static boolean isMasterURI(URI uri) {
        return SCHEME.equals(uri.getScheme());
    }
}

