/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem.internal.filesystem;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.filesystem.internal.filesystem.GEclipseFileStore;
import java.net.URI;
import java.util.Hashtable;
import org.eclipse.core.filesystem.IFileStore;

public class FileStoreRegistry {
    private static FileStoreRegistry instance;
    private Hashtable<String, GEclipseFileStore> registeredStores = new Hashtable();

    private FileStoreRegistry() {
    }

    public static FileStoreRegistry getInstance() {
        if (instance == null) {
            instance = new FileStoreRegistry();
        }
        return instance;
    }

    void putStore(GEclipseFileStore gEclipseStore) {
        GEclipseURI uri = new GEclipseURI(gEclipseStore.toURI());
        String key = this.getKey(uri.toSlaveURI());
        this.registeredStores.put(key, gEclipseStore);
    }

    GEclipseFileStore getStore(GEclipseURI gEclipseUri) {
        String key = this.getKey(gEclipseUri.toSlaveURI());
        GEclipseFileStore fileStore = this.registeredStores.get(key);
        return fileStore;
    }

    GEclipseFileStore getStore(IFileStore fileStore) {
        GEclipseURI uri = new GEclipseURI(fileStore.toURI());
        return this.getStore(uri);
    }

    GEclipseFileStore removeStore(GEclipseURI uri) {
        String key = this.getKey(uri.toSlaveURI());
        return this.registeredStores.remove(key);
    }

    GEclipseFileStore removeStore(IFileStore fileStore) {
        GEclipseURI uri = new GEclipseURI(fileStore.toURI());
        return this.removeStore(uri);
    }

    private String getKey(URI uri) {
        String scheme = uri.getScheme();
        String userInfo = uri.getUserInfo();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String query = uri.getQuery();
        String fragment = uri.getFragment();
        StringBuffer buffer = new StringBuffer();
        if (scheme != null) {
            buffer.append(this.cleanupToken(scheme));
        }
        if (userInfo != null) {
            buffer.append(this.cleanupToken(userInfo));
        }
        if (host != null) {
            buffer.append(host);
        }
        if (port >= 0) {
            buffer.append(this.cleanupToken(String.valueOf(port)));
        }
        if (path != null) {
            path = this.cleanupToken(path);
            path = path.replaceAll("^/+|/+$", "");
            buffer.append(path);
        }
        if (query != null) {
            buffer.append(this.cleanupToken(query));
        }
        if (fragment != null) {
            buffer.append(this.cleanupToken(fragment));
        }
        return buffer.toString();
    }

    private String cleanupToken(String token) {
        return token.replaceAll("^[ \t\u0000]+|[ \t\u0000]$", "");
    }
}

