/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core;

import eu.geclipse.core.internal.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionManager {
    private IExtensionRegistry registry;

    public ExtensionManager() {
        this(Platform.getExtensionRegistry());
    }

    public ExtensionManager(IExtensionRegistry registry) {
        this.registry = registry;
    }

    public IExtensionRegistry getRegistry() {
        return this.registry;
    }

    public IExtensionPoint getExtensionPoint(String extensionPointID) {
        return this.registry == null ? null : this.registry.getExtensionPoint(extensionPointID);
    }

    public List<IExtension> getExtensions(String extensionPointID) {
        IExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointID);
        List<IExtension> resultList = new ArrayList<IExtension>();
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            resultList = Arrays.asList(extensions);
        }
        return resultList;
    }

    public List<IConfigurationElement> getConfigurationElements(String extensionPointID, String configurationElementName) {
        ArrayList<IConfigurationElement> resultList = new ArrayList<IConfigurationElement>();
        List<IExtension> extensions = this.getExtensions(extensionPointID);
        for (IExtension extension : extensions) {
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int cel = 0;
            while (cel < configurationElements.length) {
                String name = configurationElements[cel].getName();
                if (name.equals(configurationElementName)) {
                    resultList.add(configurationElements[cel]);
                }
                ++cel;
            }
        }
        return resultList;
    }

    public List<Object> getExecutableExtensions(String extensionPointID, String configurationElementName, String propertyName) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        List<IConfigurationElement> configurationElements = this.getConfigurationElements(extensionPointID, configurationElementName);
        for (IConfigurationElement element : configurationElements) {
            try {
                Object obj = element.createExecutableExtension(propertyName);
                resultList.add(obj);
            }
            catch (CoreException cExc) {
                Activator.logException(cExc);
            }
        }
        return resultList;
    }
}

