/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core;

import eu.geclipse.core.Messages;
import eu.geclipse.core.Preferences;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.JobManager;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.core.model.IGridJobStatusListener;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class JobStatusUpdater
extends Job {
    private Hashtable<IGridJobStatusListener, Integer> listeners = new Hashtable();
    private IGridJob job = null;
    private IGridJobStatus lastStatus = null;
    private boolean jobRemoved;

    public JobStatusUpdater(IGridJob job) {
        super(Messages.getString("JobStatusUpdater.name"));
        this.job = job;
    }

    public IGridJob getJob() {
        return this.job;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        this.testCancelled(subMonitor);
        if (Preferences.getUpdateJobsStatus()) {
            int oldType = -1;
            if (this.lastStatus != null) {
                oldType = this.lastStatus.getType();
            }
            int newType = 128;
            IGridJobStatus newStatus = null;
            try {
                Enumeration<IGridJobStatusListener> e;
                if (this.job != null) {
                    this.testCancelled(subMonitor);
                    this.job.updateJobStatus((IProgressMonitor)subMonitor, false);
                    newStatus = this.job.getJobStatus();
                }
                if (newStatus != null) {
                    newType = newStatus.getType();
                    this.lastStatus = newStatus;
                }
                if (oldType != newType) {
                    e = this.listeners.keys();
                    while (e.hasMoreElements()) {
                        this.testCancelled(subMonitor);
                        IGridJobStatusListener listener = e.nextElement();
                        int trigger = this.listeners.get(listener);
                        if ((newType & trigger) > 0) {
                            listener.statusChanged(this.job);
                        }
                        listener.statusUpdated(this.job);
                    }
                } else {
                    e = this.listeners.keys();
                    while (e.hasMoreElements()) {
                        this.testCancelled(subMonitor);
                        IGridJobStatusListener listener = e.nextElement();
                        listener.statusUpdated(this.job);
                    }
                }
            }
            catch (RuntimeException e) {
                Activator.logException(e);
            }
            if (newStatus != null && newStatus.getReason() != null && newStatus.getReason().equals("Token request canceled") && Preferences.getJobUpdaterCancelBehaviour()) {
                Preferences.setUpdateJobsStatus(false);
                JobManager.getManager().pauseUpdater(this);
            }
            if (!this.jobRemoved && !monitor.isCanceled() && newStatus != null && newStatus.canChange()) {
                int updatePeriod = Preferences.getUpdateJobsPeriod();
                this.schedule(updatePeriod);
            } else {
                JobManager.getManager().removeJobStatusUpdater(this.job, false, monitor);
            }
        }
        return Status.OK_STATUS;
    }

    private void testCancelled(SubMonitor subMonitor) {
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void statusUpdated(IGridJobStatus newStatus) {
        block6: {
            int oldType = -1;
            if (this.lastStatus != null) {
                oldType = this.lastStatus.getType();
            }
            if (newStatus == null) break block6;
            int newType = newStatus.getType();
            if (oldType != newType) {
                this.lastStatus = newStatus;
                Enumeration<IGridJobStatusListener> e = this.listeners.keys();
                while (e.hasMoreElements()) {
                    IGridJobStatusListener listener = e.nextElement();
                    int trigger = this.listeners.get(listener);
                    if ((newType & trigger) > 0) {
                        listener.statusChanged(this.job);
                    }
                    listener.statusUpdated(this.job);
                }
            } else {
                Enumeration<IGridJobStatusListener> e = this.listeners.keys();
                while (e.hasMoreElements()) {
                    IGridJobStatusListener listener = e.nextElement();
                    listener.statusUpdated(this.job);
                }
            }
        }
    }

    public void addJobStatusListener(int status, IGridJobStatusListener listener) {
        this.listeners.put(listener, status);
    }

    public void removeJobStatusListener(IGridJobStatusListener listener) {
        this.listeners.remove(listener);
    }

    public void setRemoved() {
        this.jobRemoved = true;
    }

    public void wakeUpdater() {
        this.wakeUp();
    }
}

