/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.security.Base64;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

public class Preferences {
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final String SOCKS_SCHEME = "socks";

    public static URLConnection getURLConnection(URL url) throws IOException {
        URLConnection connection = null;
        IProxyService proxyService = Activator.getDefault().getProxyService();
        if (proxyService != null && proxyService.isProxiesEnabled()) {
            String host = url.getHost();
            String type = url.getProtocol();
            if (type.equalsIgnoreCase(HTTP_SCHEME)) {
                type = "HTTP";
            } else if (type.equalsIgnoreCase(HTTPS_SCHEME)) {
                type = "HTTPS";
            } else if (type.equalsIgnoreCase(SOCKS_SCHEME)) {
                type = "SOCKS";
            }
            IProxyData proxyData = proxyService.getProxyDataForHost(host, type);
            if (proxyData != null) {
                String proxyHost = proxyData.getHost();
                int proxyPort = proxyData.getPort();
                InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyPort);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                connection = url.openConnection(proxy);
                if (proxyData.isRequiresAuthentication()) {
                    String proxyAuthLogin = proxyData.getUserId();
                    String proxyAuthPw = proxyData.getPassword();
                    String encoded = new Base64().encode(String.valueOf(proxyAuthLogin) + ":" + proxyAuthPw);
                    connection.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                }
            }
        }
        if (connection == null) {
            connection = url.openConnection(Proxy.NO_PROXY);
        }
        return connection;
    }

    public static void setDefaultVoName(String defaultVoName) {
        org.eclipse.core.runtime.Preferences preferenceStore = Preferences.getPreferenceStore();
        preferenceStore.setValue("def_vo", defaultVoName);
    }

    public static String getDefaultVoName() {
        org.eclipse.core.runtime.Preferences preferenceStore = Preferences.getPreferenceStore();
        String defaultVoName = preferenceStore.getString("def_vo");
        return defaultVoName;
    }

    public static void setUpdateJobsStatus(boolean status) {
        org.eclipse.core.runtime.Preferences preferenceStore = Preferences.getPreferenceStore();
        preferenceStore.setValue("jobs.update.jobs.status", status);
    }

    public static boolean getUpdateJobsStatus() {
        boolean valueUpdateJobsStatus = false;
        org.eclipse.core.runtime.Preferences preferenceStore = Preferences.getPreferenceStore();
        if (preferenceStore != null) {
            valueUpdateJobsStatus = preferenceStore.getBoolean("jobs.update.jobs.status");
        }
        return valueUpdateJobsStatus;
    }

    public static void setJobUpdaterCancelBehaviour(boolean cancel) {
        org.eclipse.core.runtime.Preferences preferenceStore = Preferences.getPreferenceStore();
        preferenceStore.setValue("jobs.update.jobs.cancelBehaviour", cancel);
    }

    public static boolean getJobUpdaterCancelBehaviour() {
        boolean valueUpdateCancelBehaviour = false;
        org.eclipse.core.runtime.Preferences preferenceStore = Preferences.getPreferenceStore();
        if (preferenceStore != null) {
            valueUpdateCancelBehaviour = preferenceStore.getBoolean("jobs.update.jobs.cancelBehaviour");
        }
        return valueUpdateCancelBehaviour;
    }

    public static void setUpdateJobsPeriod(int period) {
        org.eclipse.core.runtime.Preferences preferenceStore = Preferences.getPreferenceStore();
        preferenceStore.setValue("jobs.update.jobs.period", period);
    }

    public static int getUpdateJobsPeriod() {
        int valueUpdateJobsPeriod = 30;
        org.eclipse.core.runtime.Preferences preferenceStore = Preferences.getPreferenceStore();
        if (preferenceStore != null) {
            valueUpdateJobsPeriod = preferenceStore.getInt("jobs.update.jobs.period");
        }
        return valueUpdateJobsPeriod * 1000;
    }

    public static void setUpdatersLimit(int limit) {
        org.eclipse.core.runtime.Preferences preferenceStore = Preferences.getPreferenceStore();
        preferenceStore.setValue("jobs.update.updaters.limit", limit);
    }

    public static int getUpdatersLimit() {
        org.eclipse.core.runtime.Preferences preferenceStore = Preferences.getPreferenceStore();
        int valueUpdatersLimit = preferenceStore.getInt("jobs.update.updaters.limit");
        return valueUpdatersLimit;
    }

    public static void save() {
        Activator.getDefault().savePluginPreferences();
    }

    protected static org.eclipse.core.runtime.Preferences getPreferenceStore() {
        org.eclipse.core.runtime.Preferences preferenceStore = null;
        Activator activator = Activator.getDefault();
        if (activator != null) {
            preferenceStore = activator.getPluginPreferences();
        }
        return preferenceStore;
    }
}

