/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.auth;

import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import eu.geclipse.core.security.BaseSecurityManager;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationTokenManager
extends BaseSecurityManager {
    private static AuthenticationTokenManager singleton = null;
    private List<IAuthenticationToken> tokens = new ArrayList<IAuthenticationToken>();
    private IAuthenticationToken defaultToken;

    private AuthenticationTokenManager() {
    }

    public static AuthenticationTokenManager getManager() {
        if (singleton == null) {
            singleton = new AuthenticationTokenManager();
        }
        return singleton;
    }

    public IAuthenticationToken createToken(IAuthenticationTokenDescription description) throws AuthenticationException {
        IAuthenticationToken token = description.createToken();
        this.addToken(token);
        return token;
    }

    public IAuthenticationToken findToken(IAuthenticationTokenDescription description) {
        IAuthenticationToken resultToken = null;
        for (IAuthenticationToken token : this.tokens) {
            if (!token.getDescription().equals(description)) continue;
            resultToken = token;
            break;
        }
        return resultToken;
    }

    public List<IAuthenticationToken> getTokens() {
        return new ArrayList<IAuthenticationToken>(this.tokens);
    }

    public void destroyToken(IAuthenticationToken token) throws AuthenticationException {
        this.removeToken(token);
        token.setActive(false);
    }

    public int getTokenCount() {
        return this.tokens.size();
    }

    public boolean isEmpty() {
        return this.getTokenCount() == 0;
    }

    public void setDefaultToken(IAuthenticationToken token) {
        if (token == null && this.defaultToken != null) {
            this.defaultToken = null;
            this.manageDefaultToken();
            this.fireContentChanged();
        }
        if (this.tokens.contains(token) && this.defaultToken != token) {
            this.defaultToken = token;
            this.fireContentChanged();
        }
    }

    public IAuthenticationToken getDefaultToken() {
        return this.defaultToken;
    }

    protected void addToken(IAuthenticationToken token) {
        this.tokens.add(token);
        this.manageDefaultToken();
        this.fireContentChanged();
    }

    protected boolean removeToken(IAuthenticationToken token) {
        boolean result = this.tokens.remove(token);
        if (result) {
            this.manageDefaultToken();
            this.fireContentChanged();
        }
        return result;
    }

    private boolean manageDefaultToken() {
        boolean changed = false;
        if (this.defaultToken != null && !this.tokens.contains(this.defaultToken)) {
            this.defaultToken = null;
            changed = true;
        }
        if (this.defaultToken == null && !this.tokens.isEmpty()) {
            this.defaultToken = this.tokens.get(0);
            changed = true;
        }
        return changed;
    }
}

