/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.auth;

import eu.geclipse.core.auth.AbstractAuthTokenProvider;
import eu.geclipse.core.auth.AuthTokenRequest;
import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.AuthenticationTokenManager;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import eu.geclipse.core.internal.Activator;
import java.util.List;

public class CoreAuthTokenProvider
extends AbstractAuthTokenProvider {
    public IAuthenticationToken requestToken() {
        return this.requestToken(null);
    }

    public IAuthenticationToken requestToken(AuthTokenRequest request) {
        IAuthenticationToken token = null;
        if (request == null) {
            token = AuthenticationTokenManager.getManager().getDefaultToken();
        } else {
            IAuthenticationTokenDescription description = request.getDescription();
            token = this.checkDefaultToken(description);
            if (token == null) {
                token = this.checkAnyToken(description);
            }
        }
        if (token != null) {
            AuthenticationTokenManager.getManager().setDefaultToken(token);
            try {
                if (!token.isValid()) {
                    token.validate();
                }
                if (!token.isActive()) {
                    token.setActive(true);
                }
            }
            catch (AuthenticationException authExc) {
                Activator.logException((Throwable)((Object)authExc));
            }
        }
        return token;
    }

    private IAuthenticationToken checkDefaultToken(IAuthenticationTokenDescription description) {
        IAuthenticationToken result = null;
        AuthenticationTokenManager manager = AuthenticationTokenManager.getManager();
        IAuthenticationToken token = manager.getDefaultToken();
        if (this.checkToken(token, description)) {
            result = token;
        }
        return result;
    }

    private IAuthenticationToken checkAnyToken(IAuthenticationTokenDescription description) {
        IAuthenticationToken result = null;
        AuthenticationTokenManager manager = AuthenticationTokenManager.getManager();
        List<IAuthenticationToken> tokens = manager.getTokens();
        for (IAuthenticationToken token : tokens) {
            if (!this.checkToken(token, description)) continue;
            result = token;
            break;
        }
        return result;
    }

    private boolean checkToken(IAuthenticationToken token, IAuthenticationTokenDescription description) {
        boolean result = false;
        if (token != null) {
            IAuthenticationTokenDescription tokenDescription = token.getDescription();
            result = description.matches(tokenDescription);
        }
        return result;
    }
}

