/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.auth;

import eu.geclipse.core.internal.Activator;
import java.util.Hashtable;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public abstract class PasswordManager {
    private static final String PASSWORD = "password";
    private static final int SECURE_STORAGE_NO_PASSWD_PROVIDED = 4;
    private static boolean useSecureStorage = true;
    private static Hashtable<String, String> registeredPasswords = new Hashtable();

    public static void setUseSecureStorage(boolean useSS) {
        useSecureStorage = useSS;
    }

    public static String getPassword(String pwuid) {
        String result = null;
        if (useSecureStorage) {
            ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = securePreferences.node(pwuid);
            try {
                result = node.get(PASSWORD, null);
            }
            catch (StorageException storageEx) {
                PasswordManager.handleStorageException(storageEx);
            }
        }
        if (!useSecureStorage) {
            result = registeredPasswords.get(pwuid);
        }
        return result;
    }

    public static void registerPassword(String pwuid, String pw) {
        if (useSecureStorage) {
            ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = securePreferences.node(pwuid);
            try {
                node.put(PASSWORD, pw, true);
            }
            catch (StorageException storageEx) {
                PasswordManager.handleStorageException(storageEx);
            }
        }
        if (!useSecureStorage) {
            registeredPasswords.put(pwuid, pw);
        }
    }

    public static void erasePassword(String pwuid) {
        if (useSecureStorage) {
            ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = securePreferences.node(pwuid);
            node.remove(PASSWORD);
        } else {
            registeredPasswords.remove(pwuid);
        }
    }

    private static void handleStorageException(StorageException storageExc) {
        useSecureStorage = false;
        if (storageExc.getErrorCode() != 4) {
            Activator.logException(storageExc);
        }
    }
}

