/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.config;

import eu.geclipse.core.config.IConfiguration;
import eu.geclipse.core.reporting.ProblemException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements IConfiguration {
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String VERSION_10 = "1.0";
    private static final String PARAMETER_ELEMENT = "parameter";
    private static final String KEY_ATTRIBUTE = "key";
    private static final String VALUE_ELEMENT = "value";
    private Hashtable<String, String[]> table = new Hashtable();

    public Configuration() {
    }

    public Configuration(IConfiguration configuration) {
        Set<String> keys = configuration.getKeys();
        for (String key : keys) {
            this.setParameters(key, configuration.getParameters(key));
        }
    }

    public void setParameter(String key, String value) {
        this.setParameters(key, new String[]{value});
    }

    public void setParameters(String key, String[] value) {
        this.table.put(key, value);
    }

    @Override
    public Set<String> getKeys() {
        return this.table.keySet();
    }

    @Override
    public String getParameter(String key) {
        String[] parameters = this.table.get(key);
        return parameters != null && parameters.length == 1 ? parameters[0] : null;
    }

    @Override
    public String[] getParameters(String key) {
        return this.table.get(key);
    }

    @Override
    public void loadFromXML(IFileStore store) throws ProblemException {
        this.table.clear();
        try {
            Element configNode;
            String version;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder dBuilder = factory.newDocumentBuilder();
            Document document = dBuilder.parse(store.openInputStream(0, null));
            NodeList configNodes = document.getElementsByTagName(CONFIGURATION_ELEMENT);
            if (configNodes.getLength() == 1 && VERSION_10.equals(version = (configNode = (Element)configNodes.item(0)).getAttribute(VERSION_ATTRIBUTE))) {
                NodeList parameterNodes = configNode.getElementsByTagName(PARAMETER_ELEMENT);
                int i = 0;
                while (i < parameterNodes.getLength()) {
                    Element parameterNode = (Element)parameterNodes.item(i);
                    String key = parameterNode.getAttribute(KEY_ATTRIBUTE);
                    NodeList valueNodes = parameterNode.getElementsByTagName(VALUE_ELEMENT);
                    String[] values = new String[valueNodes.getLength()];
                    int j = 0;
                    while (j < valueNodes.getLength()) {
                        values[j] = valueNodes.item(j).getTextContent();
                        ++j;
                    }
                    this.setParameters(key, values);
                    ++i;
                }
            }
        }
        catch (ParserConfigurationException pcExc) {
            throw new ProblemException("eu.geclipse.core.problem.io.operationFailed", (Throwable)pcExc, "eu.geclipse.core");
        }
        catch (SAXException saxExc) {
            throw new ProblemException("eu.geclipse.core.problem.io.operationFailed", (Throwable)saxExc, "eu.geclipse.core");
        }
        catch (IOException ioExc) {
            throw new ProblemException("eu.geclipse.core.problem.io.operationFailed", (Throwable)ioExc, "eu.geclipse.core");
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.io.operationFailed", (Throwable)cExc, "eu.geclipse.core");
        }
    }

    @Override
    public void storeToXML(IFileStore store) throws ProblemException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element configNode = document.createElement(CONFIGURATION_ELEMENT);
            configNode.setAttribute(VERSION_ATTRIBUTE, VERSION_10);
            document.appendChild(configNode);
            Set<String> keys = this.getKeys();
            for (String key : keys) {
                String[] parameters = this.getParameters(key);
                if (parameters == null || parameters.length <= 0) continue;
                Element parNode = document.createElement(PARAMETER_ELEMENT);
                parNode.setAttribute(KEY_ATTRIBUTE, key);
                configNode.appendChild(parNode);
                String[] stringArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    Element valNode = document.createElement(VALUE_ELEMENT);
                    parNode.appendChild(valNode);
                    valNode.appendChild(document.createTextNode(value));
                    ++n2;
                }
            }
            OutputStream oStream = store.openOutputStream(0, null);
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(oStream);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(domSource, streamResult);
            oStream.close();
        }
        catch (ParserConfigurationException pcExc) {
            throw new ProblemException("eu.geclipse.core.problem.io.operationFailed", (Throwable)pcExc, "eu.geclipse.core");
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.io.operationFailed", (Throwable)cExc, "eu.geclipse.core");
        }
        catch (TransformerConfigurationException tcExc) {
            throw new ProblemException("eu.geclipse.core.problem.io.operationFailed", (Throwable)tcExc, "eu.geclipse.core");
        }
        catch (TransformerException tExc) {
            throw new ProblemException("eu.geclipse.core.problem.io.operationFailed", (Throwable)tExc, "eu.geclipse.core");
        }
        catch (IOException iOException) {}
    }
}

