/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.config;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.config.Configuration;
import eu.geclipse.core.config.Configurator;
import eu.geclipse.core.config.IConfigurator;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.model.IConfigurableElementCreator;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.ICertificateLoader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ConfiguratorFactory {
    public static IConfigurator createConfigurator(IConfigurationElement element) throws ProblemException {
        Configurator result = new Configurator();
        try {
            IConfigurationElement[] projects;
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] vos;
            int n;
            IConfigurationElement[] certificates = element.getChildren("certificates");
            if (certificates != null) {
                IConfigurationElement[] iConfigurationElementArray2 = certificates;
                n = certificates.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] loaders;
                    IConfigurationElement cert = iConfigurationElementArray2[n2];
                    String loaderID = cert.getAttribute("loaderID");
                    ICertificateLoader certLoader = ConfiguratorFactory.getCertificateLoader(loaderID);
                    ArrayList<URI> uris = new ArrayList<URI>();
                    IConfigurationElement[] iConfigurationElementArray3 = loaders = cert.getChildren();
                    int n3 = loaders.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement loader = iConfigurationElementArray3[n4];
                        String certURI = null;
                        if (loader.getName().equals("certificateDistribution")) {
                            String authorityID = loader.getAttribute("authorityID");
                            String distributionID = loader.getAttribute("distributionID");
                            certURI = ConfiguratorFactory.getCertLoaderURI(loaderID, authorityID, distributionID);
                        } else if (loader.getName().equals("certificateURL")) {
                            certURI = loader.getAttribute("url");
                        }
                        if (certURI != null) {
                            try {
                                URI uri = new URI(certURI);
                                uris.add(uri);
                            }
                            catch (URISyntaxException uriExc) {
                                Activator.logException(uriExc);
                            }
                        }
                        ++n4;
                    }
                    result.addCertificateLoader(certLoader, uris.toArray(new URI[uris.size()]));
                    ++n2;
                }
            }
            if ((vos = element.getChildren("vo")) != null) {
                IConfigurationElement[] iConfigurationElementArray4 = vos;
                int n5 = vos.length;
                n = 0;
                while (n < n5) {
                    IConfigurationElement vo = iConfigurationElementArray4[n];
                    String voName = vo.getAttribute("voName");
                    String creatorID = vo.getAttribute("creatorID");
                    IConfigurableElementCreator voCreator = ConfiguratorFactory.getVoCreator(creatorID);
                    IConfigurationElement[] tokens = vo.getChildren();
                    Configuration config = new Configuration();
                    iConfigurationElementArray = tokens;
                    int n6 = tokens.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        IConfigurationElement token = iConfigurationElementArray[n7];
                        String key = token.getAttribute("key");
                        IConfigurationElement[] values = token.getChildren("parameterValue");
                        if (values != null && values.length > 0) {
                            String[] valueStrings = new String[values.length];
                            int i = 0;
                            while (i < values.length) {
                                valueStrings[i] = values[i].getAttribute("value");
                                ++i;
                            }
                            config.setParameters(key, valueStrings);
                        }
                        ++n7;
                    }
                    result.addVoCreator(voCreator, voName, config);
                    ++n;
                }
            }
            if ((projects = element.getChildren("project")) != null) {
                IConfigurationElement[] iConfigurationElementArray5 = projects;
                int n8 = projects.length;
                int n9 = 0;
                while (n9 < n8) {
                    IConfigurationElement project = iConfigurationElementArray5[n9];
                    String projectName = project.getAttribute("projectName");
                    String voName = project.getAttribute("voName");
                    IConfigurationElement[] folderElements = project.getChildren();
                    Hashtable<String, String> projectFolders = new Hashtable<String, String>();
                    iConfigurationElementArray = folderElements;
                    int n10 = folderElements.length;
                    int n11 = 0;
                    while (n11 < n10) {
                        IConfigurationElement folderElement = iConfigurationElementArray[n11];
                        String folderID = folderElement.getAttribute("folderID");
                        String folderName = folderElement.getAttribute("folderName");
                        projectFolders.put(folderID, folderName);
                        ++n11;
                    }
                    result.addProjectConfiguration(projectName, voName, projectFolders);
                    ++n9;
                }
            }
        }
        catch (ProblemException pExc) {
            throw pExc;
        }
        catch (CoreException cExc) {
            throw new ProblemException(cExc.getStatus());
        }
        return result;
    }

    private static ICertificateLoader getCertificateLoader(String loaderID) throws CoreException {
        ICertificateLoader result = null;
        ExtensionManager manager = new ExtensionManager();
        List<IConfigurationElement> loaders = manager.getConfigurationElements("eu.geclipse.core.certificateLoader", "loader");
        for (IConfigurationElement loader : loaders) {
            if (!loader.getAttribute("id").equals(loaderID)) continue;
            result = (ICertificateLoader)loader.createExecutableExtension("class");
            break;
        }
        return result;
    }

    private static IConfigurableElementCreator getVoCreator(String creatorID) throws CoreException {
        IConfigurableElementCreator result = null;
        ExtensionManager manager = new ExtensionManager();
        List<IConfigurationElement> loaders = manager.getConfigurationElements("eu.geclipse.core.gridElementCreator", "creator");
        for (IConfigurationElement loader : loaders) {
            if (!loader.getAttribute("id").equals(creatorID)) continue;
            try {
                result = (IConfigurableElementCreator)loader.createExecutableExtension("class");
                break;
            }
            catch (ClassCastException ccExc) {
                throw new ProblemException("eu.geclipse.core.problem.config.wrongVoCreator", (Throwable)ccExc, "eu.geclipse.core");
            }
        }
        return result;
    }

    private static String getCertLoaderURI(String loaderID, String authorityID, String distributionID) {
        String result = null;
        ExtensionManager manager = new ExtensionManager();
        List<IConfigurationElement> loaders = manager.getConfigurationElements("eu.geclipse.core.certificateLoader", "loader");
        block0: for (IConfigurationElement loader : loaders) {
            IConfigurationElement[] authorities;
            if (!loader.getAttribute("id").equals(loaderID)) continue;
            IConfigurationElement[] iConfigurationElementArray = authorities = loader.getChildren();
            int n = authorities.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement authority = iConfigurationElementArray[n2];
                if (authority.getAttribute("id").equals(authorityID)) {
                    IConfigurationElement[] distros;
                    IConfigurationElement[] iConfigurationElementArray2 = distros = authority.getChildren();
                    int n3 = distros.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement distro = iConfigurationElementArray2[n4];
                        if (distro.getAttribute("id").equals(distributionID)) {
                            result = distro.getAttribute("url");
                            break block0;
                        }
                        ++n4;
                    }
                    break block0;
                }
                ++n2;
            }
            break block0;
        }
        return result;
    }
}

