/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.model.AbstractGridElementManager;
import eu.geclipse.core.model.IDefaultGridElementManager;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.reporting.ProblemException;

public abstract class AbstractDefaultGridElementManager
extends AbstractGridElementManager
implements IDefaultGridElementManager {
    private IGridElement defaultElement;

    public IGridElement getDefault() {
        return this.defaultElement;
    }

    public void setDefault(IGridElement element) throws ProblemException {
        if (element != null && element != this.defaultElement) {
            this.addElement(element);
            this.defaultElement = element;
            this.updateDefault();
        }
    }

    public boolean addElement(IGridElement element) throws ProblemException {
        boolean result = super.addElement(element);
        if (result) {
            this.updateDefault();
        }
        return result;
    }

    public boolean removeElement(IGridElement element) {
        boolean result = super.removeElement(element);
        if (result) {
            this.updateDefault();
        }
        return result;
    }

    protected boolean updateDefault() {
        boolean changed = false;
        if (this.defaultElement != null && !this.contains(this.defaultElement)) {
            this.defaultElement = null;
            changed = true;
        }
        if (this.defaultElement == null && this.hasChildren()) {
            this.defaultElement = this.getChildren(null)[0];
            changed = true;
        }
        return changed;
    }
}

