/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.LocalFolder;
import eu.geclipse.core.internal.model.ProjectVo;
import eu.geclipse.core.internal.model.VoManager;
import eu.geclipse.core.internal.model.notify.GridModelEvent;
import eu.geclipse.core.internal.model.notify.GridNotificationService;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import eu.geclipse.core.project.GridProjectNature;
import eu.geclipse.core.reporting.ProblemException;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridProject
extends ResourceGridContainer
implements IGridProject {
    public static final String PROJECT_NODE = "eu.geclipse.core";
    public static final String PROJECT_FOLDER_NODE = "eu.geclipse.core.folders";
    private static final String VO_ATTRIBUTE = "vo";
    private static final QualifiedName PROJECT_FOLDER_ID_QN = new QualifiedName("eu.geclipse.core", "grid.project.folder.id");
    private ProjectVo vo;

    protected GridProject(IProject project) {
        super((IResource)project);
        this.loadProjectProperties(project);
    }

    @Override
    public boolean canContain(IGridElement element) {
        return true;
    }

    @Override
    public IGridElement[] getChildren(IProgressMonitor monitor) throws ProblemException {
        IGridElement[] children = new IGridElement[]{};
        if (this.isOpen() && !this.hasVo(children = super.getChildren(monitor))) {
            this.loadProjectProperties((IProject)this.getResource());
            children = super.getChildren(monitor);
        }
        return children;
    }

    @Override
    public int getChildCount() {
        int result = 0;
        if (this.isOpen()) {
            result = super.getChildCount();
        }
        return result;
    }

    @Override
    public IGridProject getProject() {
        return this;
    }

    @Override
    public IGridContainer getProjectFolder(Class<? extends IGridElement> elementType) {
        ResourceGridContainer result = this;
        ProjectScope projectScope = new ProjectScope((IProject)this.getResource());
        IEclipsePreferences folderNode = projectScope.getNode(PROJECT_FOLDER_NODE);
        ExtensionManager extm = new ExtensionManager();
        List<IConfigurationElement> configurationElements = extm.getConfigurationElements("eu.geclipse.core.gridProjectFolder", "folder");
        for (IConfigurationElement element : configurationElements) {
            String id = element.getAttribute("id");
            String label = folderNode.get(id, null);
            if (label == null) continue;
            String className = element.getAttribute("elementClass");
            String contributor = element.getContributor().getName();
            Class<? extends IGridElement> elementClass = null;
            Bundle bundle = Platform.getBundle((String)contributor);
            try {
                elementClass = bundle.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    elementClass = Class.forName(className);
                }
                catch (ClassNotFoundException cnfExc) {
                    Activator.logException(cnfExc);
                }
            }
            if (elementClass == null) continue;
            if (elementClass.equals(elementType)) {
                result = this.getProjectFolder(label);
                break;
            }
            if (!elementClass.isAssignableFrom(elementType)) continue;
            result = this.getProjectFolder(label);
        }
        return result;
    }

    private LocalFolder getProjectFolder(String name) {
        LocalFolder result = null;
        IGridElement child = this.findChild(name);
        if (child == null) {
            IProject project = (IProject)this.getResource();
            IFolder folder = project.getFolder(name);
            if (!folder.exists()) {
                try {
                    folder.create(1, true, null);
                    result = this.getProjectFolder(name);
                }
                catch (CoreException coreException) {}
            }
        } else if (child instanceof LocalFolder) {
            result = (LocalFolder)child;
        }
        return result;
    }

    @Override
    public IGridContainer getProjectFolder(IGridElement element) {
        return this.getProjectFolder(element.getClass());
    }

    @Override
    public String getProjectFolderID(IGridContainer folder) {
        String result = null;
        if (folder.getParent() == this) {
            String name = folder.getName();
            ProjectScope projectScope = new ProjectScope((IProject)this.getResource());
            IEclipsePreferences folderNode = projectScope.getNode(PROJECT_FOLDER_NODE);
            try {
                String[] keys;
                String[] stringArray = keys = folderNode.keys();
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    String label = folderNode.get(key, null);
                    if (name.equals(label)) {
                        result = key;
                        break;
                    }
                    ++n2;
                }
            }
            catch (BackingStoreException bsExc) {
                Activator.logException(bsExc);
            }
        }
        return result;
    }

    @Override
    public IVirtualOrganization getVO() {
        return this.vo;
    }

    @Override
    public boolean hasGridNature() {
        boolean result = false;
        IProject project = (IProject)this.getResource();
        try {
            result = project.hasNature(GridProjectNature.getID());
        }
        catch (CoreException coreException) {}
        return result;
    }

    @Override
    public boolean isOpen() {
        return ((IProject)this.getResource()).isOpen();
    }

    @Override
    protected IGridElement addElement(IGridElement element) throws ProblemException {
        IGridElement result = super.addElement(element);
        if (result != null && result instanceof IGridContainer && !result.isVirtual()) {
            try {
                GridNotificationService.getInstance().lock(this);
                boolean updated = this.updateProjectProperties((IGridContainer)element);
                if (!updated) {
                    this.updateProjectFolderProperties((IGridContainer)element);
                }
                GridNotificationService.getInstance().unlock(this);
            }
            catch (CoreException cExc) {
                Activator.logException(cExc);
            }
            catch (BackingStoreException bsExc) {
                Activator.logException(bsExc);
            }
        }
        return result;
    }

    @Override
    protected IStatus fetchChildren(IProgressMonitor monitor) {
        IStatus result = Status.CANCEL_STATUS;
        if (this.isOpen()) {
            result = super.fetchChildren(monitor);
        }
        return result;
    }

    private boolean hasVo(IGridElement[] children) {
        boolean result = false;
        IGridElement[] iGridElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (child instanceof ProjectVo) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    private void loadProjectProperties(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode(PROJECT_NODE);
        try {
            IVirtualOrganization globalVo;
            projectNode.sync();
            String voName = projectNode.get(VO_ATTRIBUTE, null);
            this.vo = null;
            VoManager voManager = VoManager.getManager();
            if (voName != null && (globalVo = (IVirtualOrganization)voManager.findChild(voName)) != null) {
                this.vo = new ProjectVo(this, globalVo);
                this.addElement(this.vo);
            }
        }
        catch (BackingStoreException bsExc) {
            Activator.logException(bsExc);
        }
        catch (ProblemException pExc) {
            Activator.logException(pExc);
        }
    }

    private boolean updateProjectFolderProperties(IGridContainer folder) throws CoreException, BackingStoreException {
        boolean result = false;
        String name = folder.getName();
        ProjectScope projectScope = new ProjectScope((IProject)this.getResource());
        IEclipsePreferences folderNode = projectScope.getNode(PROJECT_FOLDER_NODE);
        String[] stringArray = folderNode.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            String label = folderNode.get(id, null);
            if (name.equals(label)) {
                IResource resource = folder.getResource();
                resource.setSessionProperty(PROJECT_FOLDER_ID_QN, (Object)id);
                result = true;
            }
            ++n2;
        }
        if (result) {
            GridModelEvent event = new GridModelEvent(6, this, new IGridElement[]{folder});
            GridNotificationService.getInstance().queueEvent(event);
        }
        return result;
    }

    private boolean updateProjectProperties(IGridContainer folder) throws CoreException {
        ProjectScope projectScope;
        IEclipsePreferences folderNode;
        String label;
        boolean result = false;
        IResource resource = folder.getResource();
        String id = (String)resource.getSessionProperty(PROJECT_FOLDER_ID_QN);
        String name = folder.getName();
        if (id != null && !name.equals(label = (folderNode = (projectScope = new ProjectScope((IProject)this.getResource())).getNode(PROJECT_FOLDER_NODE)).get(id, null))) {
            folderNode.put(id, name);
            Job syncJob = new Job("syncProjectPreferences@" + this.getName(), (Preferences)folderNode){
                private final /* synthetic */ Preferences val$folderNode;
                {
                    this.val$folderNode = preferences;
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    try {
                        this.val$folderNode.flush();
                    }
                    catch (BackingStoreException bsExc) {
                        Activator.logException(bsExc);
                        status = Status.CANCEL_STATUS;
                    }
                    return status;
                }
            };
            syncJob.setSystem(true);
            syncJob.schedule();
            result = true;
        }
        if (result) {
            GridModelEvent event = new GridModelEvent(6, this, new IGridElement[]{folder});
            GridNotificationService.getInstance().queueEvent(event);
        }
        return result;
    }
}

