/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.JobStatusUpdater;
import eu.geclipse.core.Preferences;
import eu.geclipse.core.internal.model.Messages;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobStatus;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class JobScheduler
extends Job {
    public static final int UPDATER_NORMAL_PRIORITY = 1;
    public static final int UPDATER_HIGH_PRIORITY = 2;
    private static JobScheduler singleton;
    private ArrayList<JobStatusUpdater> startingUpdaters = new ArrayList();
    private Hashtable<JobStatusUpdater, Integer> sleepingUpdaters = new Hashtable();
    private Hashtable<JobStatusUpdater, Integer> workingUpdaters = new Hashtable();

    public JobScheduler(String name) {
        super(Messages.getString("JobManager.scheduler_name"));
        this.schedule(30000L);
    }

    public int getNumberOfRunningUpdaters() {
        return this.workingUpdaters.size();
    }

    public static JobScheduler getJobScheduler() {
        if (singleton == null) {
            singleton = new JobScheduler("");
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        if (this.startingUpdaters.size() > 0) {
            JobScheduler jobScheduler = this;
            synchronized (jobScheduler) {
                Iterator<JobStatusUpdater> iterator = this.startingUpdaters.iterator();
                int updatePeriod = Preferences.getUpdateJobsPeriod();
                ArrayList<JobStatusUpdater> resumedUpdaters = new ArrayList<JobStatusUpdater>();
                while (iterator.hasNext() && Preferences.getUpdateJobsStatus()) {
                    JobStatusUpdater updater = iterator.next();
                    IGridJob job = updater.getJob();
                    IGridJobStatus updateJobStatus = job.updateJobStatus(monitor, false);
                    if (updateJobStatus.getReason() != null && updateJobStatus.getReason().equals("Token request canceled")) {
                        if (!Preferences.getJobUpdaterCancelBehaviour()) continue;
                        Preferences.setUpdateJobsStatus(false);
                        continue;
                    }
                    updater.statusUpdated(updateJobStatus);
                    if (updateJobStatus.canChange()) {
                        updater.schedule(updatePeriod);
                        this.workingUpdaters.put(updater, 1);
                    }
                    resumedUpdaters.add(updater);
                }
                for (JobStatusUpdater up : resumedUpdaters) {
                    this.startingUpdaters.remove((Object)up);
                }
            }
        }
        if (Preferences.getUpdateJobsStatus() && this.sleepingUpdaters.size() > 0 && this.getNumberOfRunningUpdaters() < Preferences.getUpdatersLimit()) {
            JobStatusUpdater updaterToWakeUp = null;
            if (this.sleepingUpdaters.contains(2)) {
                JobStatusUpdater tempUpdater = null;
                Enumeration<JobStatusUpdater> enumeration = this.sleepingUpdaters.keys();
                while (enumeration.hasMoreElements()) {
                    tempUpdater = enumeration.nextElement();
                    if (this.sleepingUpdaters.get((Object)tempUpdater) != 2) continue;
                    updaterToWakeUp = tempUpdater;
                }
                if (updaterToWakeUp != null) {
                    updaterToWakeUp.wakeUp();
                    updaterToWakeUp.schedule(Preferences.getUpdateJobsPeriod());
                }
            } else {
                updaterToWakeUp = this.sleepingUpdaters.keys().nextElement();
                updaterToWakeUp.wakeUp();
                updaterToWakeUp.schedule(Preferences.getUpdateJobsPeriod());
            }
            this.workingUpdaters.put(updaterToWakeUp, 1);
            this.sleepingUpdaters.remove((Object)updaterToWakeUp);
        }
        while (this.getNumberOfRunningUpdaters() > Preferences.getUpdatersLimit()) {
            JobStatusUpdater updater = this.workingUpdaters.keys().nextElement();
            this.pauseUpdater(updater);
        }
        this.schedule(30000L);
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleNewUpdater(JobStatusUpdater updater) {
        if (Preferences.getUpdateJobsStatus() && this.getNumberOfRunningUpdaters() < Preferences.getUpdatersLimit()) {
            JobScheduler jobScheduler = this;
            synchronized (jobScheduler) {
                this.startingUpdaters.add(updater);
            }
        } else {
            this.sleepingUpdaters.put(updater, 1);
        }
    }

    public void pauseAllUpdaters() {
        Enumeration<JobStatusUpdater> e = this.workingUpdaters.keys();
        while (e.hasMoreElements()) {
            JobStatusUpdater updater = e.nextElement();
            this.pauseUpdater(updater);
        }
    }

    public boolean pauseUpdater(JobStatusUpdater updater) {
        boolean result = false;
        if (this.workingUpdaters.containsKey((Object)updater)) {
            result = true;
            updater.sleep();
            this.sleepingUpdaters.put(updater, 1);
            this.workingUpdaters.remove((Object)updater);
        }
        return result;
    }

    public void resumeAllUpdaters() {
        Enumeration<JobStatusUpdater> e = this.sleepingUpdaters.keys();
        while (e.hasMoreElements()) {
            JobStatusUpdater updater = e.nextElement();
            this.resumeUpdater(updater);
        }
    }

    public boolean resumeUpdater(JobStatusUpdater updater) {
        boolean result = false;
        if (this.sleepingUpdaters.containsKey((Object)updater)) {
            result = true;
            updater.wakeUpdater();
            this.workingUpdaters.put(updater, 1);
            this.sleepingUpdaters.remove((Object)updater);
            updater.schedule(30000L);
        }
        return result;
    }

    public void clearUpdater(JobStatusUpdater updater) {
        this.sleepingUpdaters.remove((Object)updater);
        this.workingUpdaters.remove((Object)updater);
    }
}

