/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.model.AbstractGridElementManager;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IServiceJob;
import eu.geclipse.core.model.IServiceJobManager;
import eu.geclipse.core.model.IServiceJobStatusListener;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceJobManager
extends AbstractGridElementManager
implements IGridModelListener,
IServiceJobManager,
IServiceJobStatusListener {
    private static final String NAME = ".tests";
    private static ServiceJobManager singleton;
    private List<IServiceJob> tests = new ArrayList<IServiceJob>();
    private List<IServiceJobStatusListener> listeners = new ArrayList<IServiceJobStatusListener>();

    @Override
    public boolean addElement(IGridElement element) throws ProblemException {
        boolean flag = super.addElement(element);
        if (element instanceof IServiceJob) {
            IServiceJob test = (IServiceJob)element;
            this.tests.add(test);
        }
        return flag;
    }

    @Override
    public boolean removeElement(IGridElement element) {
        boolean flag = super.removeElement(element);
        if (element instanceof IServiceJob) {
            this.tests.remove(element);
        }
        return flag;
    }

    @Override
    public void addGridModelListener(IGridModelListener listener) {
    }

    @Override
    public void addServiceJobStatusListener(IServiceJobStatusListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addServiceJob(IServiceJob test) {
        this.tests.add(test);
    }

    @Override
    public void gridModelChanged(IGridModelEvent event) {
        block5: {
            IGridElement[] changedElements;
            block4: {
                IGridElement[] removedElements;
                if (event.getType() != 2) break block4;
                IGridElement[] iGridElementArray = removedElements = event.getElements();
                int n = removedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement elem = iGridElementArray[n2];
                    if (elem instanceof IServiceJob) {
                        IServiceJob test = (IServiceJob)elem;
                        this.tests.remove(test);
                    }
                    ++n2;
                }
                break block5;
            }
            if (event.getType() != 3) break block5;
            IGridElement[] iGridElementArray = changedElements = event.getElements();
            int n = changedElements.length;
            int n3 = 0;
            while (n3 < n) {
                IGridElement element = iGridElementArray[n3];
                if (element instanceof IServiceJob) {
                    IServiceJob cfr_ignored_0 = (IServiceJob)element;
                }
                ++n3;
            }
        }
    }

    @Override
    public boolean canManage(IGridElement element) {
        return element instanceof IServiceJob;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static ServiceJobManager getManager() {
        if (singleton == null) {
            singleton = new ServiceJobManager();
        }
        return singleton;
    }

    public List<IServiceJob> getAvaliableTests(Object resource) {
        return this.tests;
    }

    @Override
    public IServiceJob getServiceJob(String name, IGridProject project) {
        IServiceJob result = null;
        for (IServiceJob test : this.tests) {
            if (!test.getName().equalsIgnoreCase(name) || !test.getProject().equals(project)) continue;
            result = test;
            break;
        }
        return result;
    }

    @Override
    public List<IServiceJob> getServiceJobs() {
        return this.tests;
    }

    @Override
    public void statusChanged(IServiceJob test) {
        for (IServiceJobStatusListener listener : this.listeners) {
            listener.statusChanged(test);
        }
    }
}

