/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model.notify;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.GridRoot;
import eu.geclipse.core.internal.model.LocalFile;
import eu.geclipse.core.internal.model.LocalResourceCreator;
import eu.geclipse.core.internal.model.notify.GridModelEvent;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.reporting.ProblemException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class GridElementLifecycleManager
implements IResourceDeltaVisitor {
    public static IGridElementCreator findCreator(IResource resource) {
        IGridElementCreator result = GridModel.getCreatorRegistry().getCreator((Object)resource, (Class<? extends IGridElement>)null);
        if (result == null) {
            result = new LocalResourceCreator();
        }
        result.setSource(resource);
        return result;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        switch (delta.getKind()) {
            case 1: {
                this.resourceAdded(delta.getResource());
                break;
            }
            case 2: {
                this.resourceRemoved(delta.getResource());
                break;
            }
            case 4: {
                this.resourceChanged(delta.getResource(), delta.getFlags());
            }
        }
        return true;
    }

    private void elementChanged(IGridElement element) {
        int type = 3;
        IGridContainer source = element.getParent();
        IGridElement[] elements = new IGridElement[]{element};
        this.queueEvent(type, source, elements);
    }

    private void projectStateChanged(IGridProject project) {
        int type = project.isOpen() ? 4 : 5;
        IGridContainer source = project.getParent();
        IGridElement[] elements = new IGridElement[]{project};
        this.queueEvent(type, source, elements);
    }

    private void queueEvent(int type, IGridElement source, IGridElement[] elements) {
        IGridElement src = source == null ? GridModel.getRoot() : source;
        GridModelEvent event = new GridModelEvent(type, src, elements);
        GridRoot.getGridNotificationService().queueEvent(event);
    }

    private void resourceAdded(IResource resource) {
        IGridContainer parentElement;
        IContainer parent;
        IGridElementCreator creator;
        if (resource != null && (creator = GridElementLifecycleManager.findCreator(resource)) != null && (parent = resource.getParent()) != null && (parentElement = (IGridContainer)GridRoot.getInstance().findElement((IResource)parent)) != null) {
            try {
                parentElement.create(creator);
            }
            catch (ProblemException pExc) {
                Activator.logException(pExc);
            }
        }
    }

    private void resourceChanged(IResource resource, int flags) {
        IGridElement element;
        if (resource != null && (element = GridRoot.getInstance().findElement(resource)) != null) {
            if (element instanceof IGridProject && (flags & 0x4000) != 0) {
                this.projectStateChanged((IGridProject)element);
            } else if (element instanceof LocalFile) {
                LocalFile localFile = (LocalFile)element;
                if (localFile.isProjectFoldersProperties() || localFile.isProjectProperties()) {
                    this.elementChanged(localFile.getProject());
                } else {
                    this.elementChanged(element);
                }
            } else {
                this.elementChanged(element);
            }
        }
    }

    private void resourceRemoved(IResource resource) {
        IGridContainer parent;
        IGridElement element;
        if (resource != null && (element = GridRoot.getInstance().findElement(resource)) != null && (parent = element.getParent()) != null) {
            try {
                parent.delete(element);
            }
            catch (ProblemException pExc) {
                Activator.logException(pExc);
            }
        }
    }
}

