/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.io;

import eu.geclipse.core.io.PipedOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PipedInputStream
extends InputStream {
    private int bufferSize = 100000;
    private byte[] buffer = new byte[this.bufferSize];
    private int readPos = 0;
    private int writePos = 0;
    private boolean closed = false;

    public PipedInputStream(PipedOutputStream out) throws IOException {
        this();
        this.connect(out);
    }

    public PipedInputStream() {
    }

    public void connect(PipedOutputStream out) throws IOException {
        out.connect(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        int result;
        block6: {
            result = -1;
            try {
                if (this.closed) break block6;
                PipedInputStream pipedInputStream = this;
                synchronized (pipedInputStream) {
                    while (this.readPos == this.writePos) {
                        this.notifyAll();
                        this.wait();
                    }
                    result = this.buffer[this.readPos];
                    ++this.readPos;
                    this.readPos %= this.buffer.length;
                    this.notifyAll();
                }
            }
            catch (InterruptedException exception) {
                throw new IOException(exception.getLocalizedMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int offset, int length) throws IOException {
        int result = -1;
        int off = offset;
        int len = length;
        int len1 = 0;
        if (!this.closed) {
            if (offset < 0 || len < 0 || offset + length > b.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (len == 0) {
                result = 0;
            } else {
                PipedInputStream pipedInputStream = this;
                synchronized (pipedInputStream) {
                    b[off] = (byte)this.read();
                    int realLen = Math.min(--len, this.available());
                    len1 = Math.min(this.buffer.length - this.readPos, realLen);
                    System.arraycopy(this.buffer, this.readPos, b, ++off, len1);
                    this.readPos += len1;
                    this.readPos %= this.buffer.length;
                    int len2 = realLen - len1;
                    if (len2 > 0) {
                        System.arraycopy(this.buffer, this.readPos, b, off += len1, len2);
                        this.readPos += len2;
                        this.readPos %= this.buffer.length;
                    }
                    this.notifyAll();
                    result = realLen + 1;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        int result;
        PipedInputStream pipedInputStream = this;
        synchronized (pipedInputStream) {
            result = (this.bufferSize + this.writePos - this.readPos) % this.bufferSize;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PipedInputStream pipedInputStream = this;
        synchronized (pipedInputStream) {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(int b) throws IOException {
        try {
            PipedInputStream pipedInputStream = this;
            synchronized (pipedInputStream) {
                while (this.readPos == (this.writePos + 1) % this.buffer.length) {
                    this.notifyAll();
                    this.wait();
                }
                this.buffer[this.writePos] = (byte)b;
                ++this.writePos;
                this.writePos %= this.buffer.length;
                this.notifyAll();
            }
        }
        catch (InterruptedException exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] b, int offset, int length) throws IOException {
        try {
            int off = offset;
            int len = length;
            PipedInputStream pipedInputStream = this;
            synchronized (pipedInputStream) {
                do {
                    int spaceAvail;
                    if ((spaceAvail = this.buffer.length - this.available() - 1) > 0) {
                        int writeLen = Math.min(len, spaceAvail);
                        int writeOnceLen = Math.min(this.buffer.length - this.writePos, writeLen);
                        System.arraycopy(b, off, this.buffer, this.writePos, writeOnceLen);
                        off += writeOnceLen;
                        len -= writeOnceLen;
                        this.writePos += writeOnceLen;
                        this.writePos %= this.buffer.length;
                        continue;
                    }
                    this.notifyAll();
                    this.wait();
                } while (len > 0);
                this.notifyAll();
            }
        }
        catch (InterruptedException exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }
}

