/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.model.IGridApplication;
import eu.geclipse.core.model.IGridApplicationManager;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.AbstractGridElement;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractApplicationManager
extends AbstractGridElement
implements IGridApplicationManager {
    private IVirtualOrganization vo;

    public AbstractApplicationManager(IVirtualOrganization vo) {
        this.vo = vo;
    }

    public IGridApplication[] getApplications(IGridComputing computing, IProgressMonitor monitor) throws ProblemException {
        IGridApplication[] result = null;
        IGridInfoService infoService = this.vo.getInfoService();
        if (infoService != null) {
            IGridContainer parent = this.vo;
            if (computing instanceof IGridContainer) {
                parent = (IGridContainer)((Object)computing);
            }
            result = (IGridApplication[])infoService.fetchResources(parent, this.vo, GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.applications"), null);
        }
        return result;
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(this.getName());
    }

    public IGridContainer getParent() {
        return this.getVo();
    }

    public IPath getPath() {
        return this.getParent().getPath().append(this.getName());
    }

    public IResource getResource() {
        return null;
    }

    public IVirtualOrganization getVo() {
        return this.vo;
    }

    public boolean isLocal() {
        return true;
    }
}

