/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridInstallParameters;
import eu.geclipse.core.reporting.ProblemException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;

public class GenericGridInstallParameters
implements IGridInstallParameters {
    private List<URI> sources = new ArrayList<URI>();
    private List<IGridComputing> targets = new ArrayList<IGridComputing>();
    private String tag;

    public void addSource(URI uri) {
        this.sources.add(uri);
    }

    public void addSources(URI[] uris) {
        this.sources.addAll((Collection<URI>)Arrays.asList(uris));
    }

    public void addTarget(IGridComputing computing) {
        this.targets.add(computing);
    }

    public void addTargets(IGridComputing[] computings) {
        this.targets.addAll((Collection<IGridComputing>)Arrays.asList(computings));
    }

    public URI[] getSources() {
        return this.sources.toArray(new URI[this.sources.size()]);
    }

    public IFileStore[] getSourcesAsFileStore() throws ProblemException {
        URI[] sourceURIs = this.getSources();
        IFileStore[] result = new IFileStore[sourceURIs.length];
        int i = 0;
        while (i < sourceURIs.length) {
            try {
                result[i] = EFS.getStore((URI)sourceURIs[i]);
            }
            catch (CoreException cExc) {
                if (cExc instanceof ProblemException) {
                    throw (ProblemException)((Object)cExc);
                }
                throw new ProblemException(cExc.getStatus());
            }
            ++i;
        }
        return result;
    }

    public String getTag() {
        return this.tag;
    }

    public IGridComputing[] getTargets() {
        return this.targets.toArray(new IGridComputing[this.targets.size()]);
    }

    public void setSources(URI[] uris) {
        this.sources.clear();
        this.addSources(uris);
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setTargets(IGridComputing[] targets) {
        this.targets.clear();
        this.addTargets(targets);
    }
}

