/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.model.ICreatorSourceMatcher;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.impl.AbstractGridElementCreator;
import eu.geclipse.core.model.impl.GenericVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;

public class GenericVoCreator
extends AbstractGridElementCreator
implements ICreatorSourceMatcher {
    private static final String EXTENSION_ID = "eu.geclipse.core.genericVoCreator";
    private String voName;
    private List<IGridElementCreator> serviceCreators = new ArrayList<IGridElementCreator>();
    private List<IGridService> serviceMaintainers = new ArrayList<IGridService>();

    public void createService(IGridElementCreator creator, URI fromURI) throws ProblemException {
        creator.setSource(fromURI);
        this.serviceCreators.add(creator);
    }

    public void maintainService(IGridService service) {
        this.serviceMaintainers.add(service);
    }

    public void apply(GenericVirtualOrganization vo) throws ProblemException {
        IGridElement[] children;
        IGridElement[] iGridElementArray = children = vo.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (child instanceof IGridService && !this.serviceMaintainers.contains(child)) {
                vo.delete(child);
            }
            ++n2;
        }
        for (IGridElementCreator serviceCreator : this.serviceCreators) {
            vo.create(serviceCreator);
        }
    }

    public boolean canCreate(Object source) {
        boolean result = false;
        if (source instanceof IFileStore) {
            IFileStore propertiesStore = ((IFileStore)source).getChild(".generic_vo_properties");
            IFileInfo propertiesInfo = propertiesStore.fetchInfo();
            result = propertiesInfo.exists();
        }
        return result;
    }

    public IGridElement create(IGridContainer parent) throws ProblemException {
        GenericVirtualOrganization vo = null;
        Object source = this.getSource();
        if (source == null) {
            vo = new GenericVirtualOrganization(this);
        } else if (source instanceof IFileStore) {
            IFileStore fileStore = (IFileStore)source;
            vo = new GenericVirtualOrganization(fileStore);
        }
        return vo;
    }

    public String getExtensionID() {
        return EXTENSION_ID;
    }

    public String getVoName() {
        return this.voName;
    }

    public void setVoName(String name) {
        this.voName = name;
    }
}

