/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.notify.GridElementLifecycleManager;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import eu.geclipse.core.model.impl.Messages;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class ResourceGridContainer
extends AbstractGridContainer {
    private IResource resource;

    protected ResourceGridContainer(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.resource = resource;
        this.fetchChildren(null);
    }

    public boolean isLazy() {
        return false;
    }

    public IFileStore getFileStore() {
        URI uri = this.resource.getLocationURI();
        IFileSystem fileSystem = EFS.getLocalFileSystem();
        IFileStore fileStore = fileSystem.getStore(uri);
        return fileStore;
    }

    public final String getName() {
        return this.resource.getName();
    }

    public IGridContainer getParent() {
        IGridContainer parent = null;
        IPath parentPath = this.getPath().removeLastSegments(1);
        IGridElement parentElement = GridModel.getRoot().findElement(parentPath);
        if (parentElement instanceof IGridContainer) {
            parent = (IGridContainer)parentElement;
        }
        return parent;
    }

    public IPath getPath() {
        return this.resource.getFullPath();
    }

    public IResource getResource() {
        return this.resource;
    }

    public boolean isLocal() {
        return true;
    }

    protected IStatus fetchChildren(IProgressMonitor monitor) {
        IStatus result;
        IProgressMonitor localMonitor;
        block11: {
            localMonitor = monitor != null ? monitor : new NullProgressMonitor();
            result = Status.CANCEL_STATUS;
            this.deleteAll();
            if (this.resource != null && this.resource instanceof IContainer) {
                this.lock();
                try {
                    try {
                        IResource[] members = ((IContainer)this.resource).members();
                        localMonitor.beginTask(Messages.getString("AbstractGridContainer.load_progress"), members.length);
                        IResource[] iResourceArray = members;
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource member = iResourceArray[n2];
                            try {
                                IGridElementCreator creator = this.findCreator(member);
                                if (creator != null) {
                                    this.create(creator);
                                }
                                localMonitor.worked(1);
                                if (localMonitor.isCanceled()) {
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                Activator.logException(throwable);
                            }
                            ++n2;
                        }
                        result = Status.OK_STATUS;
                    }
                    catch (CoreException cExc) {
                        Activator.logException(cExc);
                        result = new Status(4, "eu.geclipse.core", "Fetch Error", (Throwable)cExc);
                        this.unlock();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    this.unlock();
                    throw throwable;
                }
                this.unlock();
            }
        }
        localMonitor.done();
        return result;
    }

    protected IGridElementCreator findCreator(IResource res) {
        return GridElementLifecycleManager.findCreator(res);
    }
}

