/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.impl.AbstractGridElement;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class ResourceGridElement
extends AbstractGridElement {
    private IResource resource;

    protected ResourceGridElement(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.resource = resource;
    }

    public IFileStore getFileStore() {
        URI uri = this.resource.getLocationURI();
        IFileSystem fileSystem = EFS.getLocalFileSystem();
        IFileStore fileStore = fileSystem.getStore(uri);
        return fileStore;
    }

    public String getName() {
        return this.resource.getName();
    }

    public IGridContainer getParent() {
        IGridContainer parent = null;
        IPath parentPath = this.getPath().removeLastSegments(1);
        IGridElement parentElement = GridModel.getRoot().findElement(parentPath);
        if (parentElement instanceof IGridContainer) {
            parent = (IGridContainer)parentElement;
        }
        return parent;
    }

    public IPath getPath() {
        return this.resource.getFullPath();
    }

    public IResource getResource() {
        return this.resource;
    }

    public boolean isLocal() {
        return true;
    }
}

