/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.project;

import eu.geclipse.core.project.GridProjectBuilder;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class GridProjectNature
implements IProjectNature {
    private IProject project;

    public void configure() throws CoreException {
        this.addBuilder(GridProjectBuilder.getID());
    }

    public void deconfigure() throws CoreException {
        this.removeBuilder(GridProjectBuilder.getID());
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static String getID() {
        return GridProjectNature.class.getName();
    }

    private void addBuilder(String builderName) throws CoreException {
        IProject proj = this.getProject();
        IProjectDescription desc = proj.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length && !found) {
            if (commands[i].getBuilderName().equals(builderName)) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            ICommand command = desc.newCommand();
            command.setBuilderName(builderName);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            desc.setBuildSpec(newCommands);
            proj.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void removeBuilder(String builderName) throws CoreException {
        IProject proj = this.getProject();
        IProjectDescription desc = proj.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean found = false;
        int index = 0;
        while (index < commands.length && !found) {
            if (commands[index].getBuilderName().equals(builderName)) {
                found = true;
            }
            ++index;
        }
        if (found) {
            ICommand[] newCommands = new ICommand[commands.length - 1];
            System.arraycopy(commands, 0, newCommands, 0, index - 1);
            System.arraycopy(commands, index, newCommands, index - 1, commands.length - index);
            desc.setBuildSpec(newCommands);
            proj.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

