/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.security;

import eu.geclipse.core.internal.security.CertificateManager;
import eu.geclipse.core.internal.security.CertificateTrustManager;
import eu.geclipse.core.security.ICertificateManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.IPath;

public class Security {
    private static final String DEFAULT_SOCKET_PROVIDER = "SunX509";
    private static final String DEFAULT_SSL_CONTEXT_PROTOCOL = "TLS";
    private static SSLSocketFactory socketFactory;

    public static IPath getCertificateLocation() {
        return CertificateManager.getManager().getCertificateLocation();
    }

    public static ICertificateManager getCertificateManager() {
        return CertificateManager.getManager();
    }

    public static X509TrustManager getTrustManager(X509TrustManager slave) {
        return new CertificateTrustManager(slave);
    }

    public static final SSLSocketFactory getSocketFactory() throws NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, KeyStoreException, InvalidAlgorithmParameterException {
        if (socketFactory == null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(DEFAULT_SOCKET_PROVIDER);
            kmf.init(null, null);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(DEFAULT_SOCKET_PROVIDER);
            tmf.init((KeyStore)null);
            TrustManager[] trustManagers = tmf.getTrustManagers();
            int i = 0;
            while (i < trustManagers.length) {
                if (trustManagers[i] instanceof X509TrustManager) {
                    trustManagers[i] = new CertificateTrustManager((X509TrustManager)trustManagers[i]);
                }
                ++i;
            }
            SSLContext ctx = SSLContext.getInstance(DEFAULT_SSL_CONTEXT_PROTOCOL);
            ctx.init(kmf.getKeyManagers(), trustManagers, null);
            ctx.getClientSessionContext().setSessionTimeout(10);
            socketFactory = ctx.getSocketFactory();
        }
        return socketFactory;
    }

    public static void setCertificateLocation(IPath location) {
        CertificateManager.getManager().setCertificateLocation(location);
    }
}

