/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.security;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class X509Util {
    private static final String X509_CERTIFICATE_FACTORY_PROVIDER = "X.509";
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static String formatSerialNumber(BigInteger serial) {
        StringBuffer b = new StringBuffer(serial.toString(16).toUpperCase());
        if (b.length() % 2 != 0) {
            b.insert(0, "0");
        }
        int index = 2;
        index = 2;
        while (index < b.length()) {
            b.insert(index, ":");
            index += 3;
        }
        return b.toString();
    }

    public static String formatEncodedData(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            if (i > 0) {
                if (i % 16 == 0) {
                    buffer.append(LINE_SEPARATOR);
                } else {
                    buffer.append(" ");
                }
            }
            buffer.append(String.format("%02X", data[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static X509Certificate loadCertificate(InputStream iStream) throws ProblemException {
        X509Certificate result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int bytesRead;
            do {
                if ((bytesRead = iStream.read(buffer)) <= 0) continue;
                baos.write(buffer);
            } while (bytesRead == buffer.length);
        }
        catch (IOException ioExc) {
            throw new ProblemException("eu.geclipse.core.problem.auth.certificateLoadFailed", (Throwable)ioExc, "eu.geclipse.core");
        }
        try {
            iStream.close();
            baos.close();
        }
        catch (IOException ioExc) {
            Activator.logException(ioExc);
        }
        String s = new String(baos.toByteArray());
        int i1 = s.indexOf(BEGIN_CERT);
        int i2 = s.indexOf(END_CERT);
        try {
            CertificateFactory factory = CertificateFactory.getInstance(X509_CERTIFICATE_FACTORY_PROVIDER);
            if (i1 >= 0 && i2 >= 0 && i2 > i1) {
                String cString = s.substring(i1, i2 + END_CERT.length());
                byte[] bytes = cString.getBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                result = (X509Certificate)factory.generateCertificate(bais);
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                result = (X509Certificate)factory.generateCertificate(bais);
            }
        }
        catch (CertificateException certExc) {
            throw new ProblemException("eu.geclipse.core.problem.auth.certificateLoadFailed", (Throwable)certExc, "eu.geclipse.core");
        }
        return result;
    }

    public static void saveCertificate(X509Certificate c, OutputStream oStream) throws ProblemException {
        try {
            byte[] encoded = c.getEncoded();
            Base64 base64 = new Base64();
            byte[] base64encoded = base64.encode(encoded);
            PrintStream pStream = new PrintStream(oStream);
            pStream.println(BEGIN_CERT);
            int off = 0;
            while (off < base64encoded.length) {
                int len = off + 64 <= base64encoded.length ? 64 : base64encoded.length - off;
                pStream.write(base64encoded, off, len);
                pStream.println();
                off += 64;
            }
            pStream.println(END_CERT);
            pStream.close();
        }
        catch (CertificateEncodingException ceExc) {
            throw new ProblemException("eu.geclipse.core.problem.auth.credentialSaveFailed", (Throwable)ceExc, "eu.geclipse.core");
        }
    }
}

