/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.simpleTest;

import eu.geclipse.core.simpleTest.AbstractSimpleTest;
import eu.geclipse.core.simpleTest.ISimpleTestDescription;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ReachabilityTest
extends AbstractSimpleTest {
    private static int[] PORTS = new int[]{22, 80, 8080, 2170, 2135, 7443, 8085, 8443, 8446, 9003};

    public ReachabilityTest(ISimpleTestDescription description) {
        super(description);
    }

    private boolean reachPort(InetAddress address, int port) {
        boolean ret = true;
        Socket socket = new Socket();
        try {
            try {
                socket.connect(new InetSocketAddress(address, port), 3000);
                socket.close();
            }
            catch (IOException iOException) {
                ret = false;
                socket = null;
            }
        }
        finally {
            socket = null;
        }
        return ret;
    }

    public double ping(InetAddress address) {
        boolean reached = false;
        double ret = -1.0;
        if (address != null) {
            long start = System.nanoTime();
            try {
                reached = address.isReachable(3000);
            }
            catch (IOException iOException) {}
            long end = System.nanoTime();
            if (reached) {
                ret = (double)(end - start) / 1000000.0;
            } else {
                int i = 0;
                while (i < PORTS.length && !reached) {
                    start = System.nanoTime();
                    reached = this.reachPort(address, PORTS[i]);
                    ++i;
                }
                end = System.nanoTime();
                if (reached) {
                    ret = (double)(end - start) / 1000000.0;
                }
            }
        }
        return ret;
    }
}

