/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MasterMonitor
implements IProgressMonitor {
    private List<IProgressMonitor> slaves = new ArrayList<IProgressMonitor>();

    public MasterMonitor() {
        this(null, null);
    }

    public MasterMonitor(IProgressMonitor slave) {
        this(slave, null);
    }

    public MasterMonitor(IProgressMonitor slave1, IProgressMonitor slave2) {
        this.addSlave(slave1);
        this.addSlave(slave2);
    }

    public void addSlave(IProgressMonitor slave) {
        if (slave != null && !(slave instanceof NullProgressMonitor)) {
            this.slaves.add(slave);
        }
    }

    public void beginTask(String name, int totalWork) {
        for (IProgressMonitor m : this.slaves) {
            m.beginTask(name, totalWork);
        }
    }

    public void done() {
        for (IProgressMonitor m : this.slaves) {
            m.done();
        }
    }

    public void internalWorked(double work) {
        for (IProgressMonitor m : this.slaves) {
            m.internalWorked(work);
        }
    }

    public boolean isCanceled() {
        boolean result = false;
        for (IProgressMonitor m : this.slaves) {
            if (result |= m.isCanceled()) break;
        }
        if (result) {
            for (IProgressMonitor m : this.slaves) {
                m.setCanceled(true);
            }
        }
        return result;
    }

    public void setCanceled(boolean value) {
        for (IProgressMonitor m : this.slaves) {
            m.setCanceled(value);
        }
    }

    public void setTaskName(String name) {
        for (IProgressMonitor m : this.slaves) {
            m.setTaskName(name);
        }
    }

    public void subTask(String name) {
        for (IProgressMonitor m : this.slaves) {
            m.subTask(name);
        }
    }

    public void worked(int work) {
        for (IProgressMonitor m : this.slaves) {
            m.worked(work);
        }
    }
}

