/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.util;

import eu.geclipse.core.internal.Activator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SecureFile
extends File {
    private static final String SECURE_PERMISSIONS_FAILED = "Failed to set secure permissions: ";
    private static final String WARNING_FILE_NOT_DELETED = ". Warning: insecure file could not be deleted.";
    private static final long serialVersionUID = 101010123456789010L;

    public SecureFile(String pathname) {
        super(pathname);
    }

    public SecureFile(String parent, String child) {
        super(parent, child);
    }

    public SecureFile(File parent, String child) {
        super(parent, child);
    }

    public SecureFile(URI uri) {
        super(uri);
    }

    private static boolean protect(String path) {
        Status status;
        String msg;
        int retVal = 0;
        if (System.getProperty("os.name").contains("Windows")) {
            return true;
        }
        String mode = "600";
        SecureFile f = new SecureFile(path);
        if (f.isDirectory()) {
            mode = "700";
        }
        String[] cmd = new String[]{"chmod", mode, path};
        String[] env = new String[]{"PATH=/bin;/usr/bin;/usr/local/bin"};
        Runtime rt = Runtime.getRuntime();
        Process proc = null;
        try {
            proc = rt.exec(cmd, env);
        }
        catch (Exception ex) {
            String msg2 = "Failed to set secure permissions: Exception running chmod";
            Status status2 = new Status(2, "eu.geclipse.core", 0, msg2, (Throwable)ex);
            Activator.logStatus((IStatus)status2);
            return false;
        }
        InputStream eStr = proc.getErrorStream();
        BufferedReader eB = new BufferedReader(new InputStreamReader(eStr));
        InputStream oStr = proc.getInputStream();
        BufferedReader oB = new BufferedReader(new InputStreamReader(oStr));
        try {
            retVal = proc.waitFor();
        }
        catch (InterruptedException ie) {
            retVal = 1;
            msg = "Failed to set secure permissions: Exception waiting for chmod to finish";
            status = new Status(2, "eu.geclipse.core", 0, msg, (Throwable)ie);
            Activator.logStatus((IStatus)status);
        }
        if (retVal != 0) {
            String line = null;
            msg = "chmod command returned non-zero value: ";
            try {
                while ((line = eB.readLine()) != null) {
                    msg = msg.concat(String.valueOf(line) + " -- ");
                }
            }
            catch (IOException iOException) {}
            status = new Status(2, "eu.geclipse.core", SECURE_PERMISSIONS_FAILED + msg);
            Activator.logStatus((IStatus)status);
            try {
                eB.close();
                oB.close();
            }
            catch (IOException iOException) {}
            return false;
        }
        try {
            eB.close();
            oB.close();
        }
        catch (IOException iOException) {}
        return true;
    }

    public boolean setSecure() throws IOException {
        String filePath = this.getPath();
        boolean ret = SecureFile.protect(filePath);
        if (!ret) {
            throw new IOException(SECURE_PERMISSIONS_FAILED + filePath);
        }
        return ret;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean createNewFile() throws IOException {
        if (!super.createNewFile()) {
            return false;
        }
        String filePath = this.getPath();
        boolean ret = SecureFile.protect(filePath);
        if (!ret) {
            File dfile = new File(filePath);
            String msg = "";
            if (!dfile.delete()) {
                msg = WARNING_FILE_NOT_DELETED;
            }
            throw new IOException(SECURE_PERMISSIONS_FAILED + filePath + msg);
        }
        return ret;
    }

    public static SecureFile createTempFile(String prefix, String suffix) throws IOException {
        return SecureFile.createTempFile(prefix, suffix, null);
    }

    public static SecureFile createTempFile(String prefix, String suffix, File directory) throws IOException {
        File file = File.createTempFile(prefix, suffix, directory);
        String filePath = file.getPath();
        SecureFile secFile = new SecureFile(filePath);
        if (!SecureFile.protect(filePath)) {
            throw new IOException(SECURE_PERMISSIONS_FAILED + filePath);
        }
        return secFile;
    }

    public boolean renameTo(File dest) {
        return super.renameTo(dest) && SecureFile.protect(this.getPath());
    }

    public boolean mkdir() {
        return super.mkdir() && SecureFile.protect(this.getPath());
    }

    public boolean mkdirs() {
        return super.mkdirs() && SecureFile.protect(this.getPath());
    }

    public static /* bridge */ /* synthetic */ File createTempFile(String string, String string2, File file) throws IOException {
        return SecureFile.createTempFile(string, string2, file);
    }

    public static /* bridge */ /* synthetic */ File createTempFile(String string, String string2) throws IOException {
        return SecureFile.createTempFile(string, string2);
    }
}

