/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.util.tar;

import eu.geclipse.core.reporting.ProblemException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TarEntry {
    protected static final int BLOCK_SZ = 512;
    private static final int OFFSET_NAME = 0;
    private static final int OFFSET_SIZE = 124;
    private static final int OFFSET_CHECKSUM = 148;
    private static final int OFFSET_TYPE = 156;
    private static final int OFFSET_MAGIC = 257;
    private static final int OFFSET_VERSION = 263;
    private static final int OFFSET_PREFIX = 345;
    private static final int LENGTH_NAME = 100;
    private static final int LENGTH_SIZE = 12;
    private static final int LENGTH_CHECKSUM = 8;
    private static final int LENGTH_MAGIC = 6;
    private static final int LENGTH_PREFIX = 155;
    private static final byte ENTRY_TYPE_FILE = 48;
    private static final byte ENTRY_TYPE_FILE_ALT = 0;
    private static final byte ENTRY_TYPE_HARDLINK = 49;
    private static final byte ENTRY_TYPE_SOFTLINK = 50;
    private static final byte ENTRY_TYPE_CHARDEV = 51;
    private static final byte ENTRY_TYPE_BLOCKDEV = 52;
    private static final byte ENTRY_TYPE_DIR = 53;
    private static final byte ENTRY_TYPE_FIFO = 54;
    private static final byte SPACE = 32;
    private static final String MAGIC = "ustar ";
    private static final byte ENTRY_FLAG_NULL = 45;
    private static final byte ENTRY_FLAG_FILE = 102;
    private static final byte ENTRY_FLAG_DIR = 100;
    private IPath entryPath;
    private long entrySize;
    private byte entryType;

    public TarEntry(byte[] header) throws ProblemException {
        if (header.length != 512) {
            throw new ProblemException("eu.geclipse.core.problem.tar.wrongHeaderSize", "eu.geclipse.core");
        }
        if (this.assertNullEntry(header)) {
            this.entryType = (byte)45;
            this.entrySize = 0L;
            return;
        }
        this.verifyChecksum(header);
        String version = this.readString(header, 257, 6);
        if (!version.equals(MAGIC) || header[263] != 32 || header[264] != 0) {
            throw new ProblemException("eu.geclipse.core.problem.tar.unsupportedEntryType", "eu.geclipse.core");
        }
        String name = this.readString(header, 0, 100);
        String prefix = this.readString(header, 345, 155);
        if (prefix.length() != 0) {
            String sep = System.getProperty("file.separator");
            if (!prefix.endsWith(sep)) {
                prefix = prefix.concat(sep);
            }
            name = prefix.concat(name);
        }
        this.entryPath = new Path(name);
        String size = this.readString(header, 124, 11);
        try {
            size = size.replaceAll("^ +", "");
            this.entrySize = Long.parseLong(size, 8);
        }
        catch (Exception exc) {
            throw new ProblemException("eu.geclipse.core.problem.tar.invalidEntrySize", (Throwable)exc, "eu.geclipse.core");
        }
        if (header[135] != 0 && header[135] != 32) {
            throw new ProblemException("eu.geclipse.core.problem.tar.invalidEntrySize", "eu.geclipse.core");
        }
        switch ((char)header[156]) {
            case '\u0000': 
            case '0': {
                this.entryType = (byte)102;
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '6': {
                throw new ProblemException("eu.geclipse.core.problem.tar.unsupportedEntryType", "eu.geclipse.core");
            }
            case '5': {
                this.entryType = (byte)100;
                break;
            }
            default: {
                throw new ProblemException("eu.geclipse.core.problem.tar.invalidEntryType", "eu.geclipse.core");
            }
        }
    }

    private String readString(byte[] buffer, int offset, int length) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (buffer[offset + i] != 0 && i < length) {
            result = result.append((char)buffer[offset + i]);
            ++i;
        }
        return result.toString();
    }

    private void verifyChecksum(byte[] header) throws ProblemException {
        int storedChecksum;
        int checksum = 0;
        int i = 0;
        while (i < 148) {
            checksum += header[i];
            ++i;
        }
        checksum += 256;
        i = 156;
        while (i < 512) {
            checksum += header[i];
            ++i;
        }
        String s = this.readString(header, 148, 6);
        try {
            s = s.replaceAll("^ +", "");
            storedChecksum = Integer.parseInt(s, 8);
        }
        catch (Exception exc) {
            throw new ProblemException("eu.geclipse.core.problem.tar.badHeaderChecksum", (Throwable)exc, "eu.geclipse.core");
        }
        if (header[154] != 0 || header[155] != 32) {
            throw new ProblemException("eu.geclipse.core.problem.tar.badHeaderChecksum", "eu.geclipse.core");
        }
        if (checksum != storedChecksum) {
            throw new ProblemException("eu.geclipse.core.problem.tar.badHeaderChecksum", "eu.geclipse.core");
        }
    }

    private boolean assertNullEntry(byte[] header) {
        boolean isNull = true;
        byte[] byArray = header;
        int n = header.length;
        int n2 = 0;
        while (n2 < n) {
            byte i = byArray[n2];
            if (i != 0) {
                isNull = false;
                break;
            }
            ++n2;
        }
        return isNull;
    }

    public boolean isNull() {
        return this.entryType == 45;
    }

    public boolean isDirectory() {
        return this.entryType == 100;
    }

    public IPath getPath() {
        return this.entryPath;
    }

    public long getSize() {
        return this.entrySize;
    }
}

